package ru.yandex.mail.junit_extensions.program_runner;

import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Value;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public abstract class ProgramOptions {
    @FunctionalInterface
    public interface HealthCheck {
        HealthStatus check();
    }

    public static final HealthCheck NO_HEALTH_CHECK = () -> HealthStatus.UP;

    public abstract HealthCheck getHealthCheck();

    public abstract Optional<Duration> getStartTimeout();

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class JavaProgramOptions extends ProgramOptions {
        Path jarPath;
        Optional<Path> jvmOptionsFile;
        List<String> jvmOptions;
        String mainClass;
        HealthCheck healthCheck;
        Optional<Duration> startTimeout;
    }

    @Value
    @EqualsAndHashCode(callSuper = false)
    public static class NativeProgramOptions extends ProgramOptions {
        Path binaryPath;
        List<String> cmdOptions;
        HealthCheck healthCheck;
        Optional<Duration> startTimeout;
    }
}
