package ru.yandex.autotests.innerpochta.tests.malware;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.core.IsEqual;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.utils.RetryRule;
import ru.yandex.autotests.innerpochta.utils.AccountRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import javax.mail.MessagingException;

import java.util.List;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.StringContains.containsString;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.innerpochta.utils.MxConstants.*;
import static ru.yandex.autotests.innerpochta.utils.MxUtils.sendByNwsmtpWithResultIgnore;
import static ru.yandex.autotests.innerpochta.utils.MxTestProperties.mxTestProps;
import static ru.yandex.autotests.innerpochta.utils.WmiApiUtils.inMailbox;

@Stories("NWSMTP")
@Feature("Поведение доставки при спамовых письмах и вирусах")
@Aqua.Test(title = "Проверка распознования персонального спама",
        description = "Отправляем персонального спама")
@Title("PersonalSpamTest.Проверка распознования персонального спама")
@Description("Отправляем персонального спама" )
public class PersonalSpamTest {

    private static String server = mxTestProps().getMxServer();
    private static int port = mxTestProps().getMxPort();
    private Logger log = LogManager.getLogger(this.getClass());
    private TestMessage msgToRegular;
    private TestMessage msgToMailList;
    private static User sender;
    private static User receiver;
    private static User mailList;
    private static User pddUser;

    @ClassRule
    public static AccountRule accountRule = new AccountRule();
    @Rule
    public LogConfigRule newAquaLogRule = new LogConfigRule();
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @BeforeClass
    public static void setReceiversAndSender() throws Exception {
        sender = accountRule.getSenderUser();
        List<User> receivers = accountRule.getReceiverUsers();
        receiver = receivers.get(0);
        mailList = receivers.get(1);
        pddUser = receivers.get(2);
    }

    @Before
    public void preparePersonalSpamMessage() throws Exception {
        msgToRegular = new TestMessage();
        msgToRegular.setFrom(sender.getEmail());
        msgToRegular.setRecipient(receiver.getEmail());
        msgToRegular.setSubject("PersonalSpamTest " + randomAlphanumeric(20));
        msgToRegular.setText(PERSONAL_SPAM_TEXT);
        msgToRegular.saveChanges();

        msgToMailList = new TestMessage();
        msgToMailList.setFrom(sender.getEmail());
        msgToMailList.setRecipient(mailList.getEmail());
        msgToMailList.setSubject("PersonalSpamTest " + randomAlphanumeric(20));
        msgToMailList.setText(PERSONAL_SPAM_TEXT);
        msgToMailList.saveChanges();
    }

    @Before
    public void checkServerType() {
        assumeThat("Этот тест предназначен для mxback-сервера", server, containsString("mxback"));
        assumeThat("Этот тест предназначен для инстанса nwsmtp на 27 порту mxback-сервера", port, IsEqual.equalTo(27));
    }

    @Test
    public void shouldSeeMessageInSpamFolderOnSendPersonalSpamToRegularReceiver()
            throws MessagingException {
        log.info("Ожидаем получить правильный ответ сервера персональный спам");
        String response = sendByNwsmtpWithResultIgnore(msgToRegular, server, port, sender);
        assertThat("Недопустимый ответ сервера на персональный спам!", response, containsString(OK_NWSMTP_SERVER_RESPONSE));
        inMailbox(receiver).inFolder(PG_FOLDER_SPAM).shouldSeeLetterWithSubject(msgToRegular.getSubject(), "Письмо не положили в папку спам");
    }

    @Test
    public void shouldSeeMessageInInboxFolderOnSendPersonalSpamToMailList()
            throws MessagingException {
        log.info("Ожидаем получить правильный ответ сервера персональный спам");
        String response = sendByNwsmtpWithResultIgnore(msgToMailList, server, port, sender);
        assertThat("Недопустимый ответ сервера на персональный спам!", response, containsString(OK_NWSMTP_SERVER_RESPONSE));
        inMailbox(pddUser.getEmail(), pddUser.getPassword()).inFolder(PG_FOLDER_DEFAULT).shouldSeeLetterWithSubject(msgToMailList.getSubject(), "Письмо не положили в папку входящие");
    }
}
