package ru.yandex.autotests.innerpochta.tests.malware;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.utils.RetryRule;
import ru.yandex.autotests.innerpochta.utils.AccountRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.StringContains.containsString;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.innerpochta.utils.MxConstants.*;
import static ru.yandex.autotests.innerpochta.utils.MxUtils.sendByNwsmtpWithResultIgnore;
import static ru.yandex.autotests.innerpochta.utils.MxTestProperties.mxTestProps;

@Stories("NWSMTP")
@Feature("Поведение доставки при спамовых письмах и вирусах")
@Aqua.Test(title = "Проверка распознования spam'a",
        description = "Отправляем спам (письмо со строкой " +
                "«XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL*C.34X»). Проверяем, что письмо было " +
                "отклонено («Message rejected under suspicion of SPAM»)")
@Title("SpamTest.Проверка распознования spam'a")
@Description("Отправляем спам (письмо со строкой " +
        "«XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL*C.34X»). Проверяем, что письмо было " +
        "отклонено («Message rejected under suspicion of SPAM»)")
public class SpamTest {
    private static String server = mxTestProps().getMxServer();
    private static int port = mxTestProps().getMxPort();
    private Logger log = LogManager.getLogger(this.getClass());
    private TestMessage msg;
    private  final String SPAM_TEXT =
            "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL*C.34X";
    private static User sender;
    private static User receiver;

    @ClassRule
    public static AccountRule accountRule = new AccountRule();
    @Rule
    public LogConfigRule newAquaLogRule = new LogConfigRule();
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @BeforeClass
    public static void setReceiverAndSender() throws Exception {
        assumeThat("Этот тест предназначен для mxback-сервера", server, containsString("mxback"));
        assumeThat("Этот тест предназначен для инстанса nwsmtp на 27 порту mxback-сервера", port, equalTo(27));
        sender = accountRule.getSenderUser();
        receiver = accountRule.getReceiverUser();
    }

    @Before
    public void prepareStrongSpamMessage() throws Exception {
        msg = new TestMessage();
        msg.setText(SPAM_TEXT);
        msg.setFrom(sender.getEmail());
        msg.setRecipient(receiver.getEmail());
        msg.setSubject("SpamMxbackCaptchaTest " + randomAlphanumeric(20));
        msg.saveChanges();
    }

    @Test
    public void shouldSeeRejectServerResponseOnStandardSpamWithoutXYandexCaptchaEnteredHeader() {
        log.info("Отправляем спамовое письмо");
        String response = sendByNwsmtpWithResultIgnore(msg, server, port, sender);
        assertThat("Недопустимый ответ сервера на spam-письмо", response, containsString(SPAM_REJECT_NWSMTP_RESPONSE_2));
    }
}
