package ru.yandex.autotests.innerpochta.tests.malware;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.utils.RetryRule;
import ru.yandex.autotests.innerpochta.utils.AccountRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.util.Collection;

import static java.util.Arrays.asList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.StringContains.containsString;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.innerpochta.utils.MxUtils.sendByNwsmtpWithResultIgnore;
import static ru.yandex.autotests.innerpochta.utils.MxTestProperties.mxTestProps;

/**
 * User: alex89
 * Date: 14.02.14
 * https://st.yandex-team.ru/MPROTO-2809
 * <p>
 * Для писем с DMARC:reject и по которым СО вернула статус malicious проверяем, что на mxfront nwsmtp отвечает
 * 550 5.7.1 Email rejected per DMARC policy for example.com
 */

@Stories("NWSMTP")
@Feature("Поведение доставки при спамовых письмах и вирусах")
@Aqua.Test(title = "Проверка правильности ответа mxfront-сервера при strongspam'е с DMARC:reject",
        description = "Для писем с DMARC:reject и по которым СО вернула статус malicious проверяем, " +
                "что на mxfront nwsmtp отвечает 550 5.7.1 Email rejected per DMARC policy for example.com")
@Title("StrongSpamRejectDmarcTest.Проверка правильности ответа mxfront-сервера при strongspam'е с DMARC:reject")
@Description(" Для писем с DMARC:reject и по которым СО вернула статус malicious проверяем, " +
        "что на mxfront nwsmtp отвечает 550 5.7.1 Email rejected per DMARC policy for example.com")
@RunWith(Parameterized.class)
public class StrongSpamRejectDmarcTest {
    private static final String STRONG_SPAM_TEXT =
            "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STRONG-ANTI-UBE-TEST-EMAIL*C.34X";
    private static String server = mxTestProps().getMxServer();
    private static int port = mxTestProps().getMxPort();
    private Logger log = LogManager.getLogger(this.getClass());
    private TestMessage msg;
    private static User sender;
    private static User receiver;

    @ClassRule
    public static AccountRule accountRule = new AccountRule();
    @Rule
    public LogConfigRule newAquaLogRule = new LogConfigRule();
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @Parameterized.Parameter(0)
    public String domain;
    @Parameterized.Parameter(1)
    public String expectedResponse;
    @Parameterized.Parameter(2)
    public String comment;


    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return asList(
                new Object[]{"paypal.com", "550 5.7.1 Email rejected per DMARC policy for paypal.com",
                        "X-DMARC: reject paypal.com"},
                new Object[]{"yandex.by",
                        "554 5.7.1 Message rejected under suspicion of SPAM; https://ya.cc/1IrBc",
                        "X-DMARC: none yandex.by"});
    }

    @Before
    public void prepareStrongSpamMessage() throws Exception {
        assumeThat("Этот тест предназначен для MxFront серверов", server, containsString("mxfront"));
        sender = accountRule.getSenderUser();
        receiver = accountRule.getReceiverUser();
        msg = new TestMessage();
        msg.setRecipient(receiver.getEmail());
        msg.setSubject(receiver.getEmail());
        msg.setText(STRONG_SPAM_TEXT);
        msg.setFrom("somebody@" + domain);
        msg.saveChanges();
    }

    @Test
    public void shouldSeeSpecialRejectDmarcServerRespOnMxFrontIfStrongSpamSendingWithRejectDmarc()
            throws InterruptedException {
        log.info("Ожидаем получить правильный ответ сервера на strong spam");
        String response = sendByNwsmtpWithResultIgnore(msg, server, port, sender.getEmail(), sender.getPassword());
        assertThat("[MPROTO-2809] Недопустимый ответ сервера на strong spam!(1) при " + comment, response,
                containsString(expectedResponse));
    }
}
