package ru.yandex.autotests.innerpochta.tests.malware;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.utils.RetryRule;
import ru.yandex.autotests.innerpochta.utils.AccountRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.StringContains.containsString;
import static ru.yandex.autotests.innerpochta.utils.MxConstants.*;
import static ru.yandex.autotests.innerpochta.utils.MxUtils.sendByNwsmtpWithResultIgnore;
import static ru.yandex.autotests.innerpochta.utils.MxTestProperties.mxTestProps;

/**
 * User: alex89
 * Date: 14.02.14
 */

@Stories("NWSMTP")
@Feature("Поведение доставки при спамовых письмах и вирусах")
@Aqua.Test(title = "Проверка распознования strongspam'a",
        description = "Отправляем стронг-спам (письмо со строкой " +
                "«XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STRONG-ANTI-UBE-TEST-EMAIL*C.34X»). Проверяем, что письмо было " +
                "отклонено («Message rejected under suspicion of SPAM»)")
@Title("StrongSpamTest.Проверка распознования strongspam'a")
@Description("Отправляем стронг-спам (письмо со строкой " +
        "«XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STRONG-ANTI-UBE-TEST-EMAIL*C.34X»). Проверяем, что письмо было " +
        "отклонено («Message rejected under suspicion of SPAM»)")
public class StrongSpamTest {
    private static final String STRONG_SPAM_TEXT = "XJS*C4JDBQADN1.NSBN3*2IDNEN*GTUBE-STRONG-ANTI-UBE-TEST-EMAIL*C.34X";
    private static String server = mxTestProps().getMxServer();
    private static int port = mxTestProps().getMxPort();
    private static String expectedResponse;
    private Logger log = LogManager.getLogger(this.getClass());
    private TestMessage msg;
    private static User sender;
    private static User receiver;

    @ClassRule
    public static AccountRule accountRule = new AccountRule();
    @Rule
    public LogConfigRule newAquaLogRule = new LogConfigRule();
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @BeforeClass
    public static void setReceiverAndSender() throws Exception {
        sender = accountRule.getSenderUser();
        receiver = accountRule.getReceiverUser();
    }

    @Before
    public void prepareStrongSpamMessage() throws Exception {
        msg = new TestMessage();
        msg.setFrom(sender.getEmail());
        msg.setRecipient(receiver.getEmail());
        msg.setSubject(receiver.getEmail());
        msg.setText(STRONG_SPAM_TEXT);
        msg.saveChanges();
    }

    @Before
    public void prepareExpectedResponse() {
        expectedResponse = SPAM_REJECT_NWSMTP_RESPONSE_1;
        if (server.contains("back") && port == 25) {
            expectedResponse = OK_NWSMTP_SERVER_RESPONSE;
        }
    }


    @Test
    public void shouldSeeOkServerRespOnBacksAndRejectServerRespOnMxFrontIfStrongSpamSending()
            throws InterruptedException {
        log.info("Ожидаем получить правильный ответ сервера на strong spam при двух отправках");
        String response = sendByNwsmtpWithResultIgnore(msg, server, port, sender);
        assertThat("Недопустимый ответ сервера на strong spam!", response, containsString(expectedResponse));
    }
}
