package ru.yandex.autotests.innerpochta.tests.malware;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.utils.RetryRule;
import ru.yandex.autotests.innerpochta.utils.AccountRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import javax.mail.MessagingException;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.StringContains.containsString;
import static ru.yandex.autotests.innerpochta.utils.MxConstants.*;
import static ru.yandex.autotests.innerpochta.utils.MxUtils.sendByNwsmtpWithResultIgnore;
import static ru.yandex.autotests.innerpochta.utils.WmiApiUtils.inMailbox;
import static ru.yandex.autotests.innerpochta.utils.MxTestProperties.mxTestProps;

/**
 * Created by jedai on Apr 27, 2009 at 2:04:20 PM
 */
@Stories("NWSMTP")
@Feature("Поведение доставки при спамовых письмах и вирусах")
@Aqua.Test(title = "Проверка распознования вирусов",
        description = "Отправляем письмо с вирусом. Проверяем, что оно не было доставлено.")
@Title("VirusTest.Проверка распознования вирусов")
@Description("Отправляем письмо с вирусом. Проверяем, что оно не было доставлено.")
public class VirusTest {
    private static final String VIRUS_TEXT = "X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*";
    private static String expectedResponse;
    private static final int TIMEOUT = 20000;
    private static String server = mxTestProps().getMxServer();
    private static int port = mxTestProps().getMxPort();
    private static Logger log = LogManager.getLogger(VirusTest.class);
    private TestMessage msg;
    private static User sender;
    private static User receiver;

    @ClassRule
    public static AccountRule accountRule = new AccountRule();
    @Rule
    public LogConfigRule newAquaLogRule = new LogConfigRule();
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @BeforeClass
    public static void setReceiverAndSender() throws Exception {
        sender = accountRule.getSenderUser();
        receiver = accountRule.getReceiverUser();
    }

    @Before
    public void prepareVirusMessage() throws Exception {
        msg = new TestMessage();
        msg.setFrom(sender.getEmail());
        msg.setRecipient(receiver.getEmail());
        msg.setSubject("V.test" + randomAlphanumeric(30));
        msg.setText(VIRUS_TEXT);
        msg.saveChanges();
    }

    @Before
    public void prepareExpectedResponse() {
        expectedResponse = OK_NWSMTP_SERVER_RESPONSE;
        if (server.contains("back")) {
            expectedResponse = equalTo(port).matches(25) ?
                    OK_NWSMTP_SERVER_RESPONSE : VIRUS_REJECT_NWSMTP_RESPONSE;
        }
    }

    @Test
    public void sholdSeeThatVirusLetterNotInTheMailbox() throws InterruptedException, MessagingException {
        log.info("Ожидаем получить положительный ответ сервера на вирусное письмо, но недоставку его в ящик");
        String response = sendByNwsmtpWithResultIgnore(msg, server, port, sender);
        Thread.sleep(TIMEOUT);
        assertThat("Неверный ответ сервера на вирусное письмо!", response, containsString(expectedResponse));
        inMailbox(receiver).shouldNotSeeLetterWithSubject(msg.getSubject());
    }
}

