package ru.yandex.mail.pglocal.junit_jupiter;

import lombok.experimental.UtilityClass;
import lombok.val;
import org.apache.commons.lang3.SystemUtils;
import ru.yandex.mail.pglocal.BinarySandboxSource;
import ru.yandex.mail.pglocal.BinarySource;
import ru.yandex.mail.pglocal.Manager;
import ru.yandex.mail.pglocal.Server;
import ru.yandex.mail.pglocal.SynchronousCommit;
import ru.yandex.mail.pglocal.Version;

import java.nio.file.Path;
import java.util.UUID;

import static java.util.Collections.emptyList;
import static ru.yandex.mail.pglocal.junit_jupiter.Constants.DATABASE_PORT_PROPERTY;
import static ru.yandex.mail.pglocal.junit_jupiter.Constants.DATABASE_USER;

@UtilityClass
class ServerManager {
    private static final BinarySource PG_BINARY_SOURCE = new BinarySandboxSource(Version.V11);
    private static Server server = null;

    private static Path resolveServerPath() {
        val uuid = UUID.randomUUID().toString();
        return SystemUtils.getJavaIoTmpDir()
            .toPath()
            .resolve(uuid);
    }

    synchronized static Server getServer() {
        return server;
    }

    synchronized static void startServer() {
        if (server != null) {
            return;
        }

        val serverDataPath = resolveServerPath();
        val dbOptions = Manager.DbOptions.withRandomPort(DATABASE_USER);

        val options = new Manager.MasterOptions(dbOptions, SynchronousCommit.OFF, emptyList());

        val manager = new Manager(PG_BINARY_SOURCE);
        server = manager.startNewMaster(serverDataPath, options);

        System.setProperty(DATABASE_PORT_PROPERTY, String.valueOf(dbOptions.getPort()));
    }

    synchronized static void stopServer() {
        if (server == null) {
            return;
        }

        server.purge();
        server = null;
    }
}
