package ru.yandex.mail.pglocal;

import lombok.Value;

import java.nio.file.Path;
import java.util.Arrays;

public interface MigrationSource {
    String[] flywayPaths();

    @Value
    class Folder implements MigrationSource {
        Path[] paths;

        public Folder(Path... paths) {
            this.paths = paths;
        }

        @Override
        public String[] flywayPaths() {
            return Arrays.stream(paths)
                .map(path -> "filesystem:" + path.toAbsolutePath())
                .toArray(String[]::new);
        }
    }

    @Value
    class ResourceFolder implements MigrationSource {
        String[] paths;

        public ResourceFolder(String... paths) {
            this.paths = paths;
        }

        @Override
        public String[] flywayPaths() {
            return Arrays.stream(paths)
                .map(path -> "classpath:" + path)
                .toArray(String[]::new);
        }
    }
}
