package ru.lanwen.raml.rarc;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jsonschema2pojo.SourceType;
import ru.lanwen.raml.rarc.util.CodegenConfig;
import ru.lanwen.raml.rarc.util.JsonOrSchemaCodegen;
import ru.lanwen.raml.rarc.util.ResponseCodegenConfig;
import ru.lanwen.raml.rarc.util.RestAssuredRamlCodegen;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class Generate {
    public static void main(String[] args) {
        OptionParser parser = new OptionParser();

        ArgumentAcceptingOptionSpec<String> path = parser.accepts("path", "Directory with files")
                .withRequiredArg().required();

        ArgumentAcceptingOptionSpec<String> file = parser.accepts("file", "Filename")
                .withRequiredArg().required();

        ArgumentAcceptingOptionSpec<String> packageName = parser.accepts("package", "Package name of generated files")
                .withRequiredArg().required();

        ArgumentAcceptingOptionSpec<String> outputDir = parser.accepts("out", "Output dit")
                .withRequiredArg().required();

        try {
            OptionSet options = parser.parse(args);

            List<String> fileNames = options.valuesOf(file);

            for (String fileName : fileNames) {
                String pkgName = options.valueOf(packageName);
                Path output = Paths.get(options.valueOf(outputDir));

                if (fileName.endsWith("raml")) {
                    new RestAssuredRamlCodegen(
                            CodegenConfig.codegenConf()
                                    .withInputPath(Paths.get(options.valueOf(path) + "/" + fileName))
                                    .withBasePackage(pkgName)
                                    .withOutputPath(output)
                    ).generate();
                } else {
                    SourceType type;

                    if (fileName.contains("jsonschema")) {
                        type = SourceType.JSONSCHEMA;
                    } else {
                        type = SourceType.JSON;
                    }

                    new JsonOrSchemaCodegen(type,
                            ResponseCodegenConfig.config()
                                    .withInputPath(Paths.get(options.valueOf(path)))
                                    .withPackageName(pkgName)
                                    .withOutputPath(output)
                                    .withSchemaPath(fileName)
                    ).generate();
                }
            }

        } catch (Exception e) {
            try {
                parser.printHelpOn(System.out);
            } catch (IOException io) {

            }

            e.printStackTrace(System.err);
            System.exit(1);
        }

        System.exit(0);
    }
}
