JAVA_LIBRARY()

IF(JDK_VERSION == "")
    JDK_VERSION(11)
ENDIF()


OWNER(
    massaraksh
    g:mail
)


NO_LINT()


RUN_JAVA_PROGRAM(
    ru.lanwen.raml.rarc.Generate
        --path ${CURDIR}/src/main/resources
            --file jsonschema/user_journal_type.json
        --package ru.yandex.mail.common.user_journal.generated
        --out ${BINDIR}/generated
    IN
        src/main/resources/jsonschema/user_journal_type.json
    OUT_DIR
        ${BINDIR}/generated
    CLASSPATH
        mail/java/rarc
)


PEERDIR(
    mail/java/rarc

    library/java/tvmauth

    contrib/java/junit/junit

    contrib/java/com/google/code/gson/gson
    contrib/java/io/rest-assured/rest-assured
    contrib/java/org/apache/httpcomponents/httpcore
    contrib/java/org/apache/httpcomponents/httpclient
    contrib/java/org/projectlombok/lombok
    contrib/java/net/sf/jopt-simple/jopt-simple

    contrib/java/ru/qatools/commons/properties
    contrib/java/ru/yandex/qatools/secrets-loader
    contrib/java/ru/yandex/qatools/allure/allure-junit-adaptor
    contrib/java/ru/yandex/autotests/plugins/testpers/rest-assured-logger
    contrib/java/mikaelhg/urlbuilder

    contrib/java/ch/ethz/ganymed/ganymed-ssh2
)


JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)
JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)


# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/junit/junit/4.13
    contrib/java/com/google/code/gson/gson/2.8.6
    contrib/java/io/rest-assured/rest-assured/4.1.2
    contrib/java/org/apache/httpcomponents/httpcore/4.4.13
    contrib/java/org/apache/httpcomponents/httpclient/4.5.12
    contrib/java/org/projectlombok/lombok/1.18.22
    contrib/java/net/sf/jopt-simple/jopt-simple/5.0.3
    contrib/java/ru/qatools/commons/properties/2.0.RC5
    contrib/java/ru/yandex/qatools/secrets-loader/1.1
    contrib/java/ru/yandex/qatools/allure/allure-junit-adaptor/1.4.22
    contrib/java/ru/yandex/autotests/plugins/testpers/rest-assured-logger/1.3-20160203.140234-30
    contrib/java/mikaelhg/urlbuilder/1.3.2
    contrib/java/ch/ethz/ganymed/ganymed-ssh2/262
)

END()
