package ru.yandex.mail.tvmlocal.junit_jupiter;

import lombok.SneakyThrows;
import lombok.val;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import ru.yandex.mail.tvmlocal.TvmTool;

import static org.junit.jupiter.api.extension.ExtensionContext.Namespace.GLOBAL;

public class LocalTvmExtension implements BeforeAllCallback, ParameterResolver {
    private static final String TVMTOOL_KEY = "tvmtool";

    @Override
    @SneakyThrows
    public void beforeAll(ExtensionContext context) {
        val annotation = context.getRequiredTestClass().getAnnotation(WithLocalTvm.class);
        val propertyProviderClass = annotation.value();
        val provider = propertyProviderClass.getDeclaredConstructor().newInstance();
        val tool = TvmToolManager.startTvmTool(provider.getOptions());
        context.getStore(GLOBAL).put(TVMTOOL_KEY, tool);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType().equals(TvmTool.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        val tool = extensionContext.getStore(GLOBAL).get(TVMTOOL_KEY, TvmTool.class);
        if (tool == null) {
            throw new ParameterResolutionException("Tvmtool not found");
        }
        return tool;
    }
}
