package ru.yandex.mail.tvmlocal.junit_jupiter;

import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import ru.yandex.mail.tvmlocal.BinarySandboxSource;
import ru.yandex.mail.tvmlocal.BinarySource;
import ru.yandex.mail.tvmlocal.TvmTool;
import ru.yandex.mail.tvmlocal.options.TvmToolOptions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Slf4j
@UtilityClass
class TvmToolManager {
    private static final BinarySource TVMTOOL_BINARY_SOURCE = new BinarySandboxSource();
    private static final Map<TvmToolOptions, TvmTool> tools = new ConcurrentHashMap<>();

    private static void stop(TvmTool tool) {
        try {
            tool.stop();
            log.info("tvmtool on port {} stopped", tool.getPort());
        } catch (Throwable e) {
            log.error("Error stopping tvmtool on port {}. Ignore.", tool.getPort(), e);
        }
    }

    static TvmTool startTvmTool(TvmToolOptions options) {
        return tools.computeIfAbsent(options, opts -> {
            val tool = TvmTool.start(TVMTOOL_BINARY_SOURCE, opts);
            log.info("tvmtool started on port {}", tool.getPort());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                stop(tool);
            }));
            return tool;
        });
    }
}
