package ru.yandex.mail.tvmlocal.options;

import lombok.Value;

import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Value
public class TvmToolOptions {
    private static final String DIGITS = "0123456789abcdef";
    private static final int AUTH_TOKEN_LENGTH = 32;

    OptionalInt port;
    ConfigLocation configLocation;
    Mode mode;
    Map<String, String> env;
    String connectionAuthToken;

    public TvmToolOptions(OptionalInt port, ConfigLocation configLocation, Mode mode, Map<String, String> env, String connectionAuthToken) {
        this.port = port;
        this.configLocation = configLocation;
        this.mode = mode;
        this.env = env;
        this.connectionAuthToken = connectionAuthToken;

        if (connectionAuthToken.length() != AUTH_TOKEN_LENGTH) {
            throw new IllegalArgumentException("Auth token length must be exactly 32 symbols long");
        }
    }

    public static String generateAuthToken() {
        return Stream.generate(() -> ThreadLocalRandom.current().nextInt(DIGITS.length()))
            .map(DIGITS::charAt)
            .limit(AUTH_TOKEN_LENGTH)
            .map(Object::toString)
            .collect(Collectors.joining());
    }
}
