JUNIT5()

JDK_VERSION(11)

OWNER(
    imdex
    g:fininfra
)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

JAVAC_FLAGS(
    -Xlint:unchecked
)

JVM_ARGS(
    -Djava.net.preferIPv6Addresses=true
)

SIZE(medium)
REQUIREMENTS(network:full)
NO_LINT()

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)

PEERDIR(
    mail/java/tvmlocal
    contrib/java/org/junit/jupiter/junit-jupiter-api
    contrib/java/org/junit/jupiter/junit-jupiter-engine
    contrib/java/org/awaitility/awaitility/3.1.4

    contrib/java/org/slf4j/slf4j-log4j12
    contrib/java/org/apache/logging/log4j/log4j-api
    contrib/java/org/apache/logging/log4j/log4j-core
    contrib/java/org/apache/logging/log4j/log4j-1.2-api

    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
)

EXCLUDE(
    contrib/java/log4j/log4j
)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/java/tvmlocal/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/java/tvmlocal/src/test/resources **/*)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/org/slf4j/slf4j-log4j12/1.8.0-beta2
)

END()
