package ru.yandex.autotests.innerpochta.tomita;

import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.specification.RequestSpecification;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static com.jayway.restassured.RestAssured.given;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 24.04.13
 * Time: 21:28
 */
@Aqua.Test
@Title("Извлечение подписи")
@Description("Дергаем синхронные тестовые ручки qa-signature & qa-contacts")
@Features({"TOMITA", "COMPARE", "COMMON"})
@RunWith(Parameterized.class)
public class TomitaAbookContacts {

    @Rule
    public LogConfigRule rule = new LogConfigRule();

    private String send;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        List<Object[]> data = new ArrayList<Object[]>();

        data.add(new Object[]{
                "--\nООО \"ГРУПОН РУС\", Москва, 119004,ул. Александра Солженицына, д.23А, стр. 1, тел. 8 (800) " +
                        "<span class=\"wmi-callto\">500-15-34</span>, " +
                        "<a href=\"mailto:ask@groupon.ru\">ask@groupon.ru</a>"
        });


        data.add(new Object[]{
                "\n" +
                        "\n" +
                        "--\n" +
                        "Best Regards,\n" +
                        "Artem Eroshenko\n" +
                        "http://staff/eroshenkoam\n" +
                        "89989882334\n" +
                        "On Apr 24, 2013, at 4:06 PM, Pavel Zorin <pazone@yandex-team.ru> wrote:"
        });


        data.add(new Object[]{
                "-- \n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "Демьяненко Анна\n" +
                        "Менеджер проектов Яндекс.Почты\n" +
                        "Тел: +7 (495) 739-7000, доб. 3228\n" +
                        "\n" +
                        "https://staff.yandex-team.ru/demyanna"
        });


        data.add(new Object[]{
                "--\n" +
                        "Егор Ганин\n" +
                        "Менеджер проектов Яндекс.Почты\n" +
                        "*************\n" +
                        "Тел: +7 (495) 739-7000, доб. 3223\n" +
                        "ф.: +7 (495) 739-70-70\n" +
                        "www.yandex.ru\n" +
                        "*************"
        });

        data.add(new Object[]{
                "--\n" +
                        " \n" +
                        "С уважением,\n" +
                        "\n" +
                        "Секретарь-администратор екатеринбургского офиса ООО «Яндекс»\n" +
                        "Екатерина Воронова\n" +
                        "Тел. +7(343) 214-84-00, доб. 7515\n" +
                        "Моб. +7-909-011-50-70\n" +
                        "\n" +
                        "voka@yandex-team.ru\n" +
                        "www.yandex.ru"
        });


        return data;
    }

    public TomitaAbookContacts(String send) {
        this.send = send;
    }

    @Test
    public void qaContacts() throws Exception {
        RequestSpecification req = new RequestSpecBuilder().addQueryParam("e", "qa-contacts").setBody(send).build();

        String testing = given().spec(req).post(tomitaProps(Component.ANY).getTomitaTesting()).prettyPrint();
        String production = given().spec(req).post(tomitaProps(Component.ANY).getTomitaProduction()).prettyPrint();

        assertThat(testing, notDiffersWith(production));
    }

    @Test
    public void qaSignature() throws Exception {
        RequestSpecification req = new RequestSpecBuilder().addQueryParam("e", "qa-signature").setBody(send).build();

        String testing = given().spec(req).post(tomitaProps(Component.ANY).getTomitaTesting()).prettyPrint();
        String production = given().spec(req).post(tomitaProps(Component.ANY).getTomitaProduction()).prettyPrint();

        assertThat(testing, notDiffersWith(production));
    }


    @Ignore("Нужно мониторить дев абука")
    @Test
    public void asyncAbookContacts() throws Exception {
        given()
                .queryParam("e", "abook-contacts")
                .queryParam("uid", "146152574")
                .queryParam("email", "lamertester@yandex.ru")
                .body(send)
                .post(tomitaProps(Component.ANY).getTomitaTesting()).prettyPrint();
    }
}

