package ru.yandex.autotests.innerpochta.tomita;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.InfoRule;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaVersionCacheRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Collection;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.MSG_LINK_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.ToObjectConverter.wrap;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.addr;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;

@Aqua.Test
@Title("Сравниваем адреса")
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@Features({"TOMITA", "COMPARE", "ADDR"})
@RunWith(value = Parameterized.class)
public class TomitaAddrTest {
    public static final Component COMPONENT = Component.ADDR;

    protected final Logger logger = LogManager.getLogger(this.getClass());

    private DataBean bean;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> messagesId() throws Exception {
        return with(DataBean.getbeans(COMPONENT)).convert(wrap());
    }

    @ClassRule
    public static HttpClientManagerRule authClient = auth().with(tomitaProps(COMPONENT).getLoginGroup());

    @ClassRule
    public static TomitaVersionCacheRule tomitaVersionCacheRule = new TomitaVersionCacheRule();


    private final InfoRule infoWriter = new InfoRule(tomitaVersionCacheRule);

    @Rule
    public RuleChain aqua = new LogConfigRule()
            .around(new BottleMessageRule())
            .around(infoWriter);

    public TomitaAddrTest(DataBean bean) {
        this.bean = bean;
        infoWriter.setBean(bean);
    }


    @Test
    @Description("https://st.yandex-team.ru/IEX-375")
    public void withProd() throws Exception {
        String actual = addr(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting()).post()
                .via(new DefaultHttpClient()).toString();

        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));

        String expected = addr(bean)
                .setHost(tomitaProps(bean.component()).getTomitaProduction())
                .post().via(new DefaultHttpClient()).toString();

        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        assertThat(link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));

        assumeThat("Адрес не извлекся", actual, not("{\"addr\":null}"));
    }
}
