package ru.yandex.autotests.innerpochta.tomita;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.InfoRule;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaVersionCacheRule;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Message;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.UpdateHCFieldRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.autotests.plugins.testpers.html.common.Code;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Collection;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static ru.yandex.autotests.innerpochta.tomita.TomitaHotelsTest.ANSWER_TO_LOG_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.MSG_LINK_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.ToObjectConverter.wrap;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.selectBy;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.MessageObj.getMsgWithContentFlag;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.Obj.XMLVERSION_DARIA2;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.lib.junit.rules.passport.Passport.login;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.accordeon;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.html;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.link;

@Aqua.Test
@Title("Сравниваем облачные письма")
@Features({"TOMITA", "COMPARE", "CLOUD"})
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@RunWith(value = Parameterized.class)
public class TomitaCloudTest {

    public static final Component COMPONENT = Component.CLOUD;
    protected final Logger logger = LogManager.getLogger(this.getClass());

    private DataBean bean;

    protected DefaultHttpClient hc;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> messagesId() throws Exception {
        return with(DataBean.getbeans(COMPONENT)).convert(wrap());
    }

    @ClassRule
    public static HttpClientManagerRule authClient = auth().with(tomitaProps(COMPONENT).getLoginGroup());

    @ClassRule
    public static TomitaVersionCacheRule tomitaVersionCacheRule = new TomitaVersionCacheRule();


    @Rule
    public UpdateHCFieldRule updateHC = new UpdateHCFieldRule(authClient, this, "hc");

    private final InfoRule infoWriter = new InfoRule(tomitaVersionCacheRule);

    @Rule
    public RuleChain aqua = new LogConfigRule()
            .around(new BottleMessageRule())
            .around(infoWriter);

    public TomitaCloudTest(DataBean bean) {
        this.bean = bean;
        infoWriter.setBean(bean);
    }


    @Test
    public void withProd() throws Exception {
        final String json = selectBy(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));

        String msgLink = login(auth().with(tomitaProps(bean.component()).getLoginGroup()).acc(),
                props().passportHost().toURL(),
                format(MSG_LINK_PATTERN, bean.mid())).rawUrl().toString();

        final String jsonProd = selectBy(bean)
                .setHost(tomitaProps(bean.component()).getTomitaProduction())
                .post().via(hc).toString();
        String expected = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(jsonProd));
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        Assert.assertThat(format("(%s)%n", tomitaVersionCacheRule.getVersion()) +
                        link(msgLink, format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected)
        );
    }


    @Test
    public void withWmiTesting() throws Exception {
        String msgLink = login(auth().with(tomitaProps(bean.component()).getLoginGroup()).acc(),
                props().passportHost().toURL(),
                format(MSG_LINK_PATTERN, bean.mid())).rawUrl().toString();

        final String json = selectBy(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));

        Obj msg = getMsgWithContentFlag(bean.mid()).setXmlVersion(XMLVERSION_DARIA2);
        Message respProd = api(Message.class).params(msg).post().via(hc);
        String expected = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(respProd.getRawFacts()));
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        Assert.assertThat(format("(%s)%n", tomitaVersionCacheRule.getVersion()) +
                        link(msgLink, format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected)
        );
    }

}
