package ru.yandex.autotests.innerpochta.tomita;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.InfoRule;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaVersionCacheRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.UpdateHCFieldRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.autotests.plugins.testpers.html.common.Code;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Collection;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.MSG_LINK_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.ToObjectConverter.wrap;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.contacts;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;

@Aqua.Test
@Title("Сравниваем подписи")
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@Features({"TOMITA", "COMPARE", "CONTACTS"})
@RunWith(value = Parameterized.class)
public class TomitaContactsTest {

    public static final String ANSWER_TO_LOG_PATTERN = MSG_LINK_PATTERN + "%n---%n%s%n---%n%n%n";

    private DataBean bean;

    protected DefaultHttpClient hc;
    protected final Logger logger = LogManager.getLogger(this.getClass());


    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> messagesId() throws Exception {
        return with(DataBean.getbeans(Component.CONTACTS)).convert(wrap());
    }

    @ClassRule
    public static TomitaVersionCacheRule tomitaVersionCacheRule = new TomitaVersionCacheRule();

    @ClassRule
    public static HttpClientManagerRule authClient = auth().with(tomitaProps(Component.CONTACTS).getLoginGroup());

    private final InfoRule infoWriter = new InfoRule(tomitaVersionCacheRule);

    @Rule
    public UpdateHCFieldRule updateHC = new UpdateHCFieldRule(authClient, this, "hc");

    @Rule
    public RuleChain aqua = new LogConfigRule()
            .around(new BottleMessageRule())
            .around(infoWriter);


    public TomitaContactsTest(DataBean bean) {
        this.bean = bean;
        infoWriter.setBean(bean);
    }


    @Test
    public void withProd() throws Exception {
        final String json = contacts(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));


        final String jsonProd = contacts(bean)
                .setHost(tomitaProps(bean.component()).getTomitaProduction())
                .post().via(hc).toString();
        String expected = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(jsonProd));
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        assertThat(format("(%s)%n", tomitaVersionCacheRule.getVersion()) +
                link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));
    }
}
