package ru.yandex.autotests.innerpochta.tomita;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.InfoRule;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaVersionCacheRule;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Message;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.UpdateHCFieldRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Collection;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.MSG_LINK_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.ToObjectConverter.wrap;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.TomitaEventsParser.fromJson;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.events;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.MessageObj.getMsgWithContentFlag;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;

@Aqua.Test
@Title("Сравниваем события")
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@Features({"TOMITA", "COMPARE", "EVENTS"})
@RunWith(value = Parameterized.class)
public class TomitaEventsTest {

    public static final Component COMPONENT = Component.EVENTS;
    protected final Logger logger = LogManager.getLogger(this.getClass());

    private DataBean bean;

    protected DefaultHttpClient hc;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> messagesId() throws Exception {
        return with(DataBean.getbeans(COMPONENT)).convert(wrap());
    }

    @ClassRule
    public static HttpClientManagerRule authClient = auth().with(tomitaProps(COMPONENT).getLoginGroup());

    @ClassRule
    public static TomitaVersionCacheRule tomitaVersionCacheRule = new TomitaVersionCacheRule();


    @Rule
    public UpdateHCFieldRule updateHC = new UpdateHCFieldRule(authClient, this, "hc");

    private final InfoRule infoWriter = new InfoRule(tomitaVersionCacheRule);

    @Rule
    public RuleChain aqua = new LogConfigRule()
            .around(new BottleMessageRule())
            .around(infoWriter);

    public TomitaEventsTest(DataBean bean) {
        this.bean = bean;
        infoWriter.setBean(bean);
    }


    @Test
    public void withProd() throws Exception {
        String json = events(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting()).post()
                .via(new DefaultHttpClient()).toString();

        String actual = bean.firstline() + fromJson(json).prettyPrintedFacts();
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));

        String jsonProd = events(bean)
                .setHost(tomitaProps(bean.component()).getTomitaProduction())
                .post().via(new DefaultHttpClient()).toString();

        String expected = bean.firstline() + fromJson(jsonProd).prettyPrintedFacts();
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        assertThat(link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));
    }


    @Test
    public void withWmiTesting() throws Exception {
        String json = events(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(new DefaultHttpClient()).toString();

        String actual = bean.firstline() + fromJson(json).prettyPrintedFacts();
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));


        Obj msgObj = getMsgWithContentFlag(bean.mid()).setXmlVersion(Obj.XMLVERSION_DARIA2);
        Message resp = api(Message.class).params(msgObj).post().via(hc);
        String expected = bean.firstline() + fromJson(resp.getRawFacts()).prettyPrintedFacts();
        logger.info(html(accordeon("Expected (from WMI)", expected)));

        assertThat(link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));
    }

}
