package ru.yandex.autotests.innerpochta.tomita;

import org.hamcrest.Matcher;
import org.json.JSONException;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.converters.TomitaEventsParser;
import ru.yandex.autotests.innerpochta.wmi.base.BaseTest;
import ru.yandex.autotests.innerpochta.wmi.core.base.Creator;
import ru.yandex.autotests.innerpochta.wmi.core.base.anno.Credentials;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailSendMsgObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MessageObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailBoxList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailSend;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Message;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.CleanMessagesRule;
import ru.yandex.autotests.innerpochta.wmicommon.Util;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.innerpochta.tomita.matchers.DateFormatMatcher.*;
import static ru.yandex.autotests.innerpochta.tomita.matchers.DateMatcher.afterCurrent;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;


@Aqua.Test
@Title("Тестирование томиты СЕГОДНЯ, ЗАВТРА")
@Description("Отправка различных html писем, затем сравнение полученного с ожидаемым")
@Features({"TOMITA", "COMMON", "EVENTS"})
@RunWith(Parameterized.class)
@Ignore("Изменился формат выдачи даты - DARIA-40298")
@Credentials(loginGroup = TomitaTodayYesterdayTest.LOGIN_GROUP)
public class TomitaTodayYesterdayTest extends BaseTest {
    public static final String SUBJ_PREF = "TomitaDays";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String LOGIN_GROUP = "TomitaTodayYesterdayTest";
    private String subj;

    private String text;
    private List<Matcher<? super Date>> matchers;

    public TomitaTodayYesterdayTest(String text, List<Matcher<? super Date>> matchers) {
        this.text = text;
        this.matchers = matchers;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getData() {
        List<Object[]> data = new ArrayList<Object[]>();

        data.add(new Object[]{"В пятницу, 3 числа, я собираюсь отпраздновать свой день рождения",
                Arrays.asList(afterCurrent(), dayOfWeekShort("Пт"))
        });

        data.add(new Object[]{"В пятницу, 3 сентября, я собираюсь отпраздновать свой день рождения",
                Arrays.asList(dayOfMonth(3))
        });

        data.add(new Object[]{"Ок, давай тогда встречаться в пятницу в 19:40",
                Arrays.asList(afterCurrent(), dayOfWeekShort("Пт"))
        });

        data.add(new Object[]{"Завтра будет дан старт антитеррористической операции",
                Arrays.asList(tomorrow())
        });

        data.add(new Object[]{"Завтра будет большая пьянка на моей хате, приходите",
                Arrays.asList(tomorrow())
        });

//        path.add(new Object[]{"Сбор желудей-переростков пройдет сегодня",
//                Arrays.asList(afterCurrent(), today())
//        });

        data.add(new Object[]{"Днюха у меня ровно через неделю.",
                Arrays.asList(afterDays(7))
        });

        return data;
    }

    @Rule
    public CleanMessagesRule clean = CleanMessagesRule.with(authClient).inbox().outbox();

    @Test
    public void tomitaToday() throws Exception {
        logger.warn("Тестирование томиты на слово сегодня, завтра, день недели");
        logger.info("Отправлен текст: " + text);

        // Отправка необходимого
        send(text);

        // Ждем доставки
        waitWith.subj(subj).waitDeliver();
        String facts = getFacts();

        assertThat("В выдаче должны содержаться и факты и адреса",
                facts, allOf(containsString("addr"), containsString("events")));
        Date date = getDateFromFacts(facts);
        assertThat("Отправлен текст: " + text, date, allOf(matchers.toArray(new Matcher[matchers.size()])));
    }


    private Date getDateFromFacts(String facts) throws ParseException, JSONException {
        TomitaEventsParser parser = new TomitaEventsParser(facts);

        assertThat("Неверное количество извлеченных фактов", parser.getEvents(), hasSize(1));

        String time = ""; //parser.getEvents().get(0).getTime();

        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        return format.parse(time);
    }


    /**
     * Отправка писем с определенным html кодом
     *
     * @param send - хтмл код
     * @throws java.io.IOException *
     */
    private void send(String send) throws IOException {
        logger.trace("Send");
        MailSendMsgObj msg = new Creator(hc, authClient.acc())
                .getMailSendMsgObjFactory().getSimpleEmptySelfMsg();
        msg.setTtypeHtml()
                .setSubj(SUBJ_PREF + Util.getRandomString())
                .setSend(send);

        api(MailSend.class).setHost(props().productionHost()).params(msg).post().via(hc);

        subj = msg.getSubj();
        clean.subject(subj);
    }

    /**
     * Получение тега content с содержимым в виде строки
     *
     * @return String - распечатка куска xml
     * @throws java.io.IOException *
     */
    private String getFacts() throws IOException {
        String mid = jsx(MailBoxList.class).post().via(hc).getMidOfMessage(subj);
        return api(Message.class)
                .params(MessageObj
                        .getMsgWithContentFlag(mid).setXmlVersion(Obj.XMLVERSION_DARIA2))
                .post().via(hc)
                .getRawFacts();
    }

}
