package ru.yandex.autotests.innerpochta.tomita;

import com.jayway.jsonassert.JsonAssert;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.InfoRule;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaVersionCacheRule;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Message;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.UpdateHCFieldRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.autotests.plugins.testpers.html.common.Code;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import java.util.Collection;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.MSG_LINK_PATTERN;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.tomita.core.converters.ToObjectConverter.wrap;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.classifier;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.unsubscribe;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.StringDiffer.notDiffersWith;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.MessageObj.getMsgWithContentFlag;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.Obj.XMLVERSION_DARIA2;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;

@Aqua.Test
@Title("Сравниваем отписки")
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@Features({"TOMITA", "COMPARE", "UNSUBSCRIBE"})
@RunWith(value = Parameterized.class)
public class TomitaUnsubscribeTest {

    public static final String ANSWER_TO_LOG_PATTERN = MSG_LINK_PATTERN + "%n---%n%s%n---%n%n%n";
    public static final Component COMPONENT = Component.UNSUBSCRIBE;

    private DataBean bean;

    protected DefaultHttpClient hc;
    protected final Logger logger = LogManager.getLogger(this.getClass());


    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> messagesId() throws Exception {
        return with(DataBean.getbeans(COMPONENT)).convert(wrap());
    }

    @ClassRule
    public static TomitaVersionCacheRule tomitaVersionCacheRule = new TomitaVersionCacheRule();

    @ClassRule
    public static HttpClientManagerRule authClient = auth().with(tomitaProps(COMPONENT).getLoginGroup());

    private final InfoRule infoWriter = new InfoRule(tomitaVersionCacheRule);

    @Rule
    public UpdateHCFieldRule updateHC = new UpdateHCFieldRule(authClient, this, "hc");

    @Rule
    public RuleChain aqua = new LogConfigRule()
            .around(new BottleMessageRule())
            .around(infoWriter);


    public TomitaUnsubscribeTest(DataBean bean) {
        this.bean = bean;
        infoWriter.setBean(bean);
    }


    @Test
    public void withProd() throws Exception {
        final String json = unsubscribe(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));


        final String jsonProd = unsubscribe(bean)
                .setHost(tomitaProps(bean.component()).getTomitaProduction())
                .post().via(hc).toString();
        String expected = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(jsonProd));
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        assertThat(format("(%s)%n", tomitaVersionCacheRule.getVersion()) +
                link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));
    }


    @Test
    @Ignore("Пока не выкатили - отключено")
    public void classifierData() throws Exception {
        final String json = classifier(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));


        JsonAssert.with(json).assertThat("qa-classifier", notNullValue())
                .assertThat("qa-classifier.labels", hasItem(COMPONENT.name().toLowerCase()));
    }



    //    @Test  //not tested yet
    public void withWmiTesting() throws Exception {
        final String json = unsubscribe(bean)
                .setHost(tomitaProps(bean.component()).getTomitaTesting())
                .post().via(hc).toString();
        final String actual = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(json));
        logger.info(html(accordeon("Actual (" + tomitaVersionCacheRule.getVersion() + ")", actual)));


        Obj msg = getMsgWithContentFlag(bean.mid()).setXmlVersion(XMLVERSION_DARIA2);
        Message respProd = api(Message.class).params(msg).post().via(hc);
        String expected = format(ANSWER_TO_LOG_PATTERN, bean.mid(), Code.format(respProd.getRawFacts()));
        logger.info(html(accordeon("Expected (" + tomitaVersionCacheRule.getProdVersion() + ")", expected)));

        assertThat(format("(%s)%n", tomitaVersionCacheRule.getVersion()) +
                link(format(MSG_LINK_PATTERN, bean.mid()), format(MSG_LINK_PATTERN, bean.mid())),
                actual, notDiffersWith(expected));
    }
}
