package ru.yandex.autotests.innerpochta.tomita;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.EmptyObj.empty;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;

/**
 * Подробно о сервисе
 * http://wiki.yandex-team.ru/users/kohen/infexsrv
 * <p/>
 * http://wiki.yandex-team.ru/users/kohen/iex/hotels
 */
@Aqua.Test
@Title("Вывод json содержимого работы томиты")
@Description("https://wiki.yandex-team.ru/ps/iex/results/")
@Features({"TOMITA", "COMPARE", "VACANCY"})
@RunWith(Parameterized.class)
public class TomitaVacancyTest {
//    @Parameterized.Parameters
//    public static Collection<Object[]> data() throws IOException {
//        File filtered = new File("/Users/lanwen/tomita_200K_2");
//        return with(FileUtils.readLines(filtered)).convert(new Converter<String, Object[]>() {
//            @Override
//            public Object[] convert(String from) {
//                return new Object[] {from};
//            }
//        });

//    }

    private DefaultHttpClient hc = auth().notAuthHC();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private String content;

    public TomitaVacancyTest(String content) {
        this.content = content;
    }

    @Test
    public void withProd() throws Exception {
        api(Factextract.class).params(empty().add(true, "e", "vacancy").setContent(content)).post().via(hc).withDebugPrint();
    }

}
