package ru.yandex.autotests.innerpochta.tomita.core;

import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.annotations.With;
import ru.yandex.qatools.properties.providers.MapOrSyspropPathReplacerProvider;

import java.net.URI;
import java.util.Properties;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 16.04.13
 * Time: 18:45
 */
@Resource.Classpath("tomita-component.${map.tomita.component}.properties")
@With(MapOrSyspropPathReplacerProvider.class)
public class TomitaProps {

    private TomitaProps(Component component) {
        Properties map = new Properties();
        map.put("tomita.component", component.toString().toLowerCase());
        PropertyLoader.populate(this, map);
    }

    public static final String MSG_LINK_PATTERN = "http://mail.yandex.ru/msg?ids=%s";

    private static TomitaProps instance;

    public static TomitaProps tomitaProps(Component component) {
        if (instance == null || !component.equals(instance.getComponent())) {
            instance = new TomitaProps(component);
        }
        return instance;
    }

    @Property("tomita.data.path")
    private String datapath = ContentGenUtils.class.getCanonicalName().replace(".", "/") + "/";

    @Property("tomita.data.name")
    private String dataname = "data-any.json";

    @Property("tomita.data.export")
    private String dataexport = "data-export.txt";

    @Property("tomita.testing")
    private String tomitaTesting = "http://iex-testing.cmail.yandex.net/";

    @Property("tomita.production")
    private String tomitaProduction = "http://mail-extract.mail.yandex.net/factextract/";

    @Property("sanitizer.uri")
    private URI sanitizerUri = URI.create("http://127.0.0.1:1010/");

    @Property("tomita.component")
    private Component component;


    @Property("tomita.fid.good")
    private String fidGood;


    @Property("tomita.fid.bad")
    private String fidBad;


    @Property("tomita.login.group")
    private String loginGroup;


    @Property("need.extract.component")
    private boolean needExtract = true;


    public String getTomitaProduction() {
        return tomitaProduction;
    }

    public String getTomitaTesting() {
        return tomitaTesting;
    }

    public URI sanitizerUri() {
        return sanitizerUri;
    }

    public Component getComponent() {
        return component;
    }

    public String getFidGood() {
        return fidGood;
    }

    public String getFidBad() {
        return fidBad;
    }

    public String getLoginGroup() {
        return loginGroup;
    }

    public String dataname() {
        return dataname;
    }

    public String dataexport() {
        return dataexport;
    }

    public String datapath() {
        return datapath;
    }

    public boolean needExtract() {
        return needExtract;
    }
}
