package ru.yandex.autotests.innerpochta.tomita.core.beans;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.isNotEmpty;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 11.10.12
 * Time: 12:52
 */
public class CalendarEvent {

    public static final String PLACE1 = "Место1: %s%n";
    public static final String PLACE2 = "Место2: %s%n";
    public static final String PLACE3 = "Место3: %s%n";
    public static final String PLACE4 = "Место4: %s%n";
    public static final String PLACE5 = "Место5: %s%n";
    public static final String EVENT = "Событие: %s%n";
    public static final String AGENT = "Агент: %s%n";
    public static final String TIME = "Время проведения: %s%n";

    public static final String CANCEL = "ОТМЕНЯЕТСЯ\n";
    public static final String RESCHEDULE = "ПЕРЕНЕСЕНО\n";
    public static final String UNTIL = "ДЕЙСТВУЕТ ДО\n";

    private Boolean cancel;
    private Boolean until;
    private Boolean reschedule;
    private String event;
    private String place1 = "";
    private String place2 = "";
    private String place3 = "";
    private String place4 = "";
    private String place5 = "";
    private String time;
    private String agent = "";


    public String getTime() {
        return time;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(cancel ? CANCEL : "")
                .append(formatNotEmpty(place1, PLACE1))
                .append(formatNotEmpty(place2, PLACE2))
                .append(formatNotEmpty(place3, PLACE3))
                .append(formatNotEmpty(place4, PLACE4))
                .append(formatNotEmpty(place5, PLACE5))
                .append(formatNotEmpty(agent, AGENT))
                .append(formatNotEmpty(event, EVENT))
                .append(reschedule ? RESCHEDULE : "")
                .append(formatNotEmpty(time, TIME))
                .append(until ? UNTIL : "");
        return sb.toString();
    }

    private String formatNotEmpty(String what, String pattern) {
        return isNotEmpty(what) ? format(pattern, what) : "";
    }
}
