package ru.yandex.autotests.innerpochta.tomita.core.beans;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang.StringUtils;
import ru.yandex.autotests.innerpochta.tomita.prepare.TomitaDataPrepare;

import java.util.List;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.defaultIfEmpty;
import static org.apache.commons.lang3.StringUtils.substringAfterLast;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.qatools.elliptics.ElClient.elliptics;
import static ru.yandex.qatools.elliptics.ElClient.ellipticsNewOne;

/**
 * User: lanwen
 * Date: 11.10.13
 * Time: 19:31
 */
public class DataBean {
    private Component component;
    private String fid;
    private String originalMessageId = "";
    private String types = "";
    private String contentPath;
    private String sender = "";
    private String timestamp = "0";
    private String mid;
    private String firstline = "";
    private transient String data;

    public String firstline() {
        return firstline;
    }

    public DataBean firstline(String firstline) {
        this.firstline = firstline;
        return this;
    }

    public String types() {
        return types;
    }

    public DataBean types(String types) {
        this.types = types;
        return this;
    }

    public String domain() {
        return defaultIfEmpty(substringAfterLast(sender, "@"), "unknown.ru");
    }

    public DataBean sender(String senderEmail) {
        this.sender = senderEmail;
        return this;
    }

    public String sender() {
        return sender;
    }

    public Component component() {
        return component;
    }

    public String timestamp() {
        return timestamp;
    }

    public DataBean date(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String mid() {
        return mid;
    }

    public DataBean mid(String mid) {
        this.mid = mid;
        return this;
    }

    public String fid() {
        return fid;
    }

    public String path() {
        return contentPath;
    }


    public DataBean component(Component component) {
        this.component = component;
        return this;
    }

    public DataBean fid(String fid) {
        this.fid = fid;
        return this;
    }

    public DataBean path(String path) {
        this.contentPath = path;
        return this;
    }


    public String url() {
        return elliptics().name(path()).get().url();
    }


    public String data() {
        if (data == null) {
            data = ellipticsNewOne().name(path()).get().asString();
        }
        return data;
    }

    public String originalMessageId() {
        return originalMessageId;
    }

    public DataBean originalMessageId(String msgId) {
        originalMessageId = msgId;
        return this;
    }

    @Override
    public String toString() {
        return format("%s-%s", mid, domain());
    }

    /**
     * Фабрика создания нового экземпляра
     *
     * @param mid - мид письма в ящике
     *
     * @return DataBean
     */
    public static DataBean fromMid(String mid) {
        return new DataBean().mid(mid);
    }

    public static DataBean fromBean(DataBean bean) {
        return new DataBean()
                .component(bean.component())
                .mid(bean.mid())
                .fid(bean.fid())
                .originalMessageId(bean.originalMessageId())
                .sender(bean.sender())
                .types(bean.types())
                .path(bean.path())
                .date(bean.timestamp())
                .firstline(bean.firstline());
    }

    /**
     * Получение пачки бинов из эллиптикса, используя проперти для создания адреса
     *
     * @return - список бинов (всех)
     */
    public static List<DataBean> getbeans(Component component) {
        final String json = elliptics().path(tomitaProps(component).datapath())
                .name(tomitaProps(component).dataname()).get().asString();
        if (StringUtils.isEmpty(json)) {
            throw new IllegalStateException(
                    format("Can't get JSON with list of beans from %s. Please update it with %s",
                            elliptics().path(tomitaProps(component).datapath())
                                    .name(tomitaProps(component).dataname()).get().url(),
                            TomitaDataPrepare.class.getSimpleName()
                    )
            );
        }
        return new Gson().fromJson(json, new TypeToken<List<DataBean>>() {
        }.getType());
    }

}
