package ru.yandex.autotests.innerpochta.tomita.core.converters;

import ch.lambdaj.function.convert.StringConverter;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;

import java.util.Map;

import static com.google.common.base.Joiner.on;

/**
 * User: lanwen
 * Date: 04.11.13
 * Time: 20:39
 */
public class DataBeanToUrlConverter implements StringConverter<DataBean> {
    public static final String SEPARATOR = "::";

    private Map<DataBean, String> respUrlMap;
    private Map<DataBean, String> reqUrlMap;

    public DataBeanToUrlConverter(Map<DataBean, String> respUrlMap, Map<DataBean, String> reqUrlMap) {
        this.respUrlMap = respUrlMap;
        this.reqUrlMap = reqUrlMap;
    }

    @Override
    public String convert(DataBean bean) {
        return on(SEPARATOR).join(reqUrlMap.get(bean), bean.url(), respUrlMap.get(bean));
    }

    public static DataBeanToUrlConverter urlExtractor(Map<DataBean, String> resp, Map<DataBean, String> req) {
        return new DataBeanToUrlConverter(resp, req);
    }
}
