package ru.yandex.autotests.innerpochta.tomita.core.converters;

import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.Lists;

import java.util.List;

import static ch.lambdaj.collection.LambdaCollections.with;


/**
 * User: lanwen
 * Date: 14.10.13
 * Time: 12:48
 */
public class ToObjectConverter<T> implements Converter<T, Object[]> {
    private List<Object> objs;

    public ToObjectConverter(List<Object> objs) {
        this.objs = objs;
    }

    public static <T> ToObjectConverter wrapAndAddTo(Object... obj) {
        return new ToObjectConverter<T>(Lists.newArrayList(obj));
    }

    public static ToObjectConverter wrap() {
        return wrapAndAddTo();
    }

    @Override
    public Object[] convert(T from) {
        return with(objs).clone().append(from).toArray();
    }
}
