package ru.yandex.autotests.innerpochta.tomita.core.converters;

import com.google.gson.*;
import org.apache.commons.lang.StringUtils;
import ru.yandex.autotests.innerpochta.tomita.core.beans.CalendarEvent;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 11.10.12
 * Time: 15:27
 */
public class TomitaEventsParser {
    private List<String> events;

    public TomitaEventsParser(String factsJson) {
        events = events(StringUtils.defaultIfEmpty(factsJson, "{}"));
    }

    public static TomitaEventsParser fromJson(String factsJson) {
        return new TomitaEventsParser(factsJson);
    }

    private List<String> events(String factsJson) {
        //Распарсиваем этот некрасивый json в человеки-читаемый вид
        List<String> events = new ArrayList<>();
        JsonObject jsObj = new JsonParser().parse(factsJson).getAsJsonObject();

        if (!jsObj.has("events")) {
            return events;
        }

        if (jsObj.get("events").isJsonNull()) {
            return events;
        }

        for (JsonElement o : jsObj.getAsJsonArray("events")) {  //was calendar in 1.2-59
            if (o.getAsJsonObject().has("CalendarEvent")) {
                Gson gson = new GsonBuilder()
                        .setPrettyPrinting()
                        .setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE)
                        .registerTypeAdapter(Boolean.class, new IntToBoolDeserializer())
                        .create();
                events.add(gson.toJson(o.getAsJsonObject().get("CalendarEvent")));
            }
        }

        return events;
    }

    public List<String> getEvents() {
        return events;
    }


    /**
     * Парсим жсон объект и аппендим его строковое представление к общему логу
     */
    public String prettyPrintedFacts() {
        StringBuilder sb = new StringBuilder("\n-----------------------------------\n");

        if (events.isEmpty()) {
            sb.append("ФАКТОВ НЕ ИЗВЛЕЧЕНО\n");
        }

        for (String event : events) {
            sb.append(event);
        }

        sb.append("-----------------------------------\n\n");
        return sb.toString();
    }

}
