package ru.yandex.autotests.innerpochta.tomita.core.matchers;

import org.hamcrest.FeatureMatcher;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;

import static org.hamcrest.Matchers.equalTo;

/**
 * User: lanwen
 * Date: 15.10.13
 * Time: 13:57
 */
public class DataBeanMatchers {

    public static FeatureMatcher<DataBean, Component> hasComponent(Component component) {
        return new FeatureMatcher<DataBean, Component>(equalTo(component), "component", "actual component") {
            @Override
            protected Component featureValueOf(DataBean dataBean) {
                return dataBean.component();
            }
        };
    }

    public static FeatureMatcher<DataBean, String> hasMid(String mid) {
        return new FeatureMatcher<DataBean, String>(equalTo(mid), "mid", "actual mid") {
            @Override
            protected String featureValueOf(DataBean dataBean) {
                return dataBean.mid();
            }
        };
    }
}
