package ru.yandex.autotests.innerpochta.tomita.core.opers;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.tomita.core.TomitaProps;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static com.google.common.base.Joiner.on;
import static java.net.URLEncoder.encode;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.EmptyObj.empty;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 23.03.12
 * Time: 14:54
 * в sjsx нету
 */

@OperClass(
        apicommand = "",
        apipath = "",
        description = "Запрос в томиту"
)
public class Factextract extends Oper<Factextract> {

    public static Factextract selectBy(DataBean bean) {

        switch (bean.component()) {
            case SANITIZER: {
                return sanitizer(bean);
            }
            case TICKETS: {
                return tickets(bean);
            }
            case EVENTS: {
                return events(bean);
            }
            case UNSUBSCRIBE: {
                return unsubscribe(bean);
            }
            case CONTACTS: {
                return contacts(bean);
            }
            case HOTELS: {
                return hotels(bean);
            }
            case BOUNCE: {
                return bounce(bean);
            }
            case DATE: {
                return date(bean);
            }
            case ADDR: {
                return addr(bean);
            }
            case CLASSIFIER: {
                return classifier(bean);
            }
            case CLASSIFIER_BOUNCE: {
                return classifier(bean);
            }
            case CLASSIFIER_TICKETS: {
                return classifier(bean);
            }
            case CLASSIFIER_UNSUBSCRIBE: {
                return classifier(bean);
            }
            case CLASSIFIER_HOTELS: {
                return classifier(bean);
            }
            case CLASSIFIER_EVENTS: {
                return classifier(bean);
            }
            case REGISTRATION: {
                return registration(bean);
            }
            case DELIVERY: {
                return delivery(bean);
            }
            case CLOUD: {
                return cloud(bean);
            }

            default: {
                throw new IllegalStateException("Компонент не найден! " + bean.component());
            }
        }
    }


    /**
     * /factextract/?e=ticket&domain=yandex.ru&mid=2380000002240469371&time=1372618129&types=5,12,16
     * Билеты (тип 5,16)
     */
    public static Factextract tickets(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "ticket")
                .set(true, "domain", content.domain())
                .set(true, "mid", content.mid())
                .set(true, "time_zone", "0")
                .set(true, "time", time(content))
                .set(true, "types", content.types())
                .setContent(content.data()));
    }

    public static Factextract events(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "abook-contacts,events,unsubscribe")
                .set(true, "domain", content.domain())
                .set(true, "email", content.sender())
                .set(true, "mid", content.mid())
                .set(true, "time", time(content))
                .set(true, "uid", "146152574")
                .setContent(content.data()));
    }


    public static Factextract addr(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "addr")
                .setContent(content.data()));
    }


    public static Factextract classifier(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "qa-classifier")
                .setContent(content.data()));
    }

    public static Factextract date(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "date")
                .set(true, "time", time(content))
                .setContent(content.data()));
    }


    /**
     * Отписки (все письма кроме отелей, билетов, отлупов)
     */
    public static Factextract unsubscribe(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "unsubscribe")
                .set(true, "domain", content.domain())
                .setContent(content.data()));
    }


    /**
     * Брони отелей 35,19 (одновременно)
     * http://wiki.yandex-team.ru/users/kohen/iex/hotels
     */
    public static Factextract hotels(DataBean content, String... whatElse) {
        return api(Factextract.class).params(empty()
                .set(true, "e", on(",").join("hotels", on(",").join(whatElse)))
                .set(true, "domain", content.domain())
                .set(true, "time", time(content))
                .set(true, "types", content.types())
                .setContent(content.data()));
    }


    /**
     * Подписи
     */
    public static Factextract contacts(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "qa-signature")
                .set(true, "email", content.sender())
                .set(true, "uid", "146152574")
                .setContent(content.data()));
    }


    /**
     * Отлупы (тип 8)
     */
    public static Factextract bounce(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "bounce")
                .set(true, "mid", content.mid())
                .set(true, "original_message_id", encode(content.originalMessageId()))
                .set(true, "types", content.types()) // вообще у отлупов 8 тип
                .set(true, "time", time(content))
                .setContent(content.data()));
    }

    /**
     * Регистрационные письма (тип 2)
     */
    public static Factextract registration(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "registration")
                .set(true, "mid", content.mid())
                .set(true, "domain", content.domain())
                .set(true, "types", content.types())
                .setContent(content.data()));
    }

    /**
     * Доставка
     */
    public static Factextract delivery(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "delivery")
                .set(true, "mid", content.mid())
                .set(true, "domain", content.domain())
                .set(true, "time", time(content))
                .set(true, "types", content.types())
                .setContent(content.data()));
    }

    /**
     * Доставка
     */
    public static Factextract cloud(DataBean content) {
        return api(Factextract.class).params(empty()
                .set(true, "e", "cloud")
                .set(true, "mid", content.mid())
                .set(true, "domain", content.domain())
                .set(true, "time", time(content))
                .set(true, "types", content.types())
                .setContent(content.data()));
    }

    /**
     * Санитайзер
     */
    public static Factextract sanitizer(DataBean content) {
        return api(Sanitizer.class).setHost(TomitaProps.tomitaProps(content.component()).sanitizerUri().toString())
                .params(empty().setContent(content.data()));
    }


    public static String time(DataBean content) {
        // Moscow time fix
        // https://st.yandex-team.ru/IEX-221
        Long timestamp = Long.valueOf(content.timestamp());// - HOURS.toSeconds(4);
        return timestamp.toString();
    }


    public String uri() {
        return "/" + obj.asGet(true);
    }

}
