package ru.yandex.autotests.innerpochta.tomita.core.rules;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.tomita.core.HtmlUtil;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.plugins.testpers.html.common.HtmlUtils.*;
import static ru.yandex.qatools.elliptics.ElClient.elliptics;


/**
 * User: lanwen
 * Date: 23.10.13
 * Time: 15:29
 */
public class InfoRule extends TestWatcher {

    protected final Logger logger = LogManager.getLogger(this.getClass());
    private DataBean bean;
    private TomitaVersionCacheRule collectorRule;

    public InfoRule(TomitaVersionCacheRule collectorRule) {
        this.collectorRule = collectorRule;
    }

    public InfoRule setBean(DataBean bean) {
        this.bean = bean;
        return this;
    }

    @Override
    protected void starting(Description description) {
        assertThat("Стоит сначала инициализировать бин", bean, notNullValue());


        logger.info(link(elliptics()
                .name(tomitaProps(bean.component()).datapath() + tomitaProps(bean.component())
                        .dataname()).get().url(), "All beans"));

        logger.info(link(elliptics()
                .name(tomitaProps(bean.component()).datapath() + tomitaProps(bean.component())
                        .dataexport()).get().url(), "All exported beans"));


        final String url = elliptics().path(this.getClass()).randomize().name(".htm")
                .put(HtmlUtil.addUtf8MetaHtml(bean.data()))
                .get().url();

        logger.warn("Account: " + auth().with(tomitaProps(bean.component()).getLoginGroup()).acc());
        logger.info(html(accordeon("Исходник", iframe(url))));
        String versions = collectorRule.getProdVersion() + " -> " + collectorRule.getVersion();
        logger.warn(versions);
        logger.info("FirstLine: " + bean.firstline());
    }
}
