package ru.yandex.autotests.innerpochta.tomita.core.rules;

import com.google.gson.Gson;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.qatools.elliptics.ElName;

import static org.apache.commons.lang3.StringUtils.defaultIfEmpty;
import static ru.yandex.autotests.innerpochta.tomita.core.TomitaProps.tomitaProps;
import static ru.yandex.qatools.elliptics.ElClient.elliptics;

/**
 * User: lanwen
 * Date: 07.04.14
 * Time: 21:59
 */
public class TomitaDataCollector extends TestWatcher {
    private static Logger log = LogManager.getLogger(TomitaDataCollector.class);

    private TomitaDataPublisher collector;
    private DataBean data;
    private String reqUrl;
    private String respDataUrl;
    private ElName ell;


    private TomitaDataCollector(TomitaDataPublisher collector) {
        this.collector = collector;
        this.ell = elliptics();
    }

    public static TomitaDataCollector withPublisher(TomitaDataPublisher collector) {
        return new TomitaDataCollector(collector);
    }

    @Override
    protected void starting(Description description) {
        // обнуляем
        data = null;
        reqUrl = null;
        respDataUrl = null;

        for (Component component : collector.components()) {
            ell.path(tomitaProps(component).datapath())
                    .name(tomitaProps(component).dataname())
                    .log().asLink("Список всех адресов до тестовых данных - " + component);

            ell.path(tomitaProps(component).datapath())
                    .name(tomitaProps(component).dataexport())
                    .log(log).asLink("Список всех адресов до тестовых данных [Экспорт для томиты] - " + component);
        }
    }

    @Override
    protected void succeeded(Description description) {
        if (data != null) {
            log.warn(new Gson().toJson(data));
            collector.addBean(data);

            collector.putReqUrl(data, reqUrl);
            collector.putRespUrl(data, defaultIfEmpty(respDataUrl, "\t"));
        }
    }

    public void setData(DataBean data) {
        this.data = data;
    }

    public TomitaDataCollector reqUrl(String reqUrl) {
        this.reqUrl = reqUrl;
        return this;
    }

    public TomitaDataCollector respDataUrl(String respDataUrl) {
        this.respDataUrl = respDataUrl;
        return this;
    }
}