package ru.yandex.autotests.innerpochta.tomita.core.rules;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

import static com.google.common.base.Joiner.on;
import static com.jayway.restassured.RestAssured.get;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 19.03.13
 * Time: 23:16
 * <p/>
 * Так же есть старый файл с историей запусков
 * elliptics().indefinitely().path(description.getTestClass()).name("results.json")
 */
public class TomitaVersionCacheRule extends TestWatcher {

//    iex-grammars - только события
//    iex-patterns - только билеты
//    iex-conf - и то и другое
//    iex-server - и то и другое

    public static final String IEX_GRAMMARS = "iex-grammars";
    public static final String IEX_PATTERNS = "iex-patterns";
    public static final String IEX_CONF = "iex-conf";
    public static final String IEX_SERVER = "iex-server";
    public static final String IEX_REMORPH = "iex-remorph";
    public static final String IEX_SERVER_DBG = "iex-server-dbg";

    public static final String TESTING = "testing";
    public static final String STABLE = "stable";

    public static final String VERSION_URL =
            "http://c.yandex-team.ru/api/generator/eeight.{state}_version?package={name}";

    private String version;
    private String prodversion;


    @Override
    protected void starting(Description description) {
        version = testingVersion();
        prodversion = productionVersion();
    }

    public static String productionVersion() {
        return on("_").join(
                versionFor(IEX_GRAMMARS, STABLE),
                versionFor(IEX_PATTERNS, STABLE),
                versionFor(IEX_CONF, STABLE),
                versionFor(IEX_SERVER, STABLE),
                versionFor(IEX_REMORPH, STABLE),
                versionFor(IEX_SERVER_DBG, STABLE)

        );
    }

    public static String testingVersion() {
        return on("_").join(
                versionFor(IEX_GRAMMARS, TESTING),
                versionFor(IEX_PATTERNS, TESTING),
                versionFor(IEX_CONF, TESTING),
                versionFor(IEX_SERVER, TESTING),
                versionFor(IEX_REMORPH, TESTING),
                versionFor(IEX_SERVER_DBG, TESTING)
        );
    }

    private static String versionFor(String name, String state) {
        return on(".").join(name, get(VERSION_URL, state, name).asString());
    }

    public String getVersion() {
        return version;
    }


    public String getProdVersion() {
        return prodversion;
    }
}
