package ru.yandex.autotests.innerpochta.tomita.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 28.09.12
 * Time: 16:10
 */
public class DateFormatMatcher extends TypeSafeMatcher<Date> {
    private String format = "EEE";
    private String toCompare;

    public DateFormatMatcher(String format, String toCompare) {
        this.format = format;
        this.toCompare = toCompare;
    }

    @Override
    protected boolean matchesSafely(Date item) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, new Locale("ru", "RU"));
        return formatter.format(item).equals(toCompare);
    }

    @Override
    protected void describeMismatchSafely(Date item, Description mismatchDescription) {
        mismatchDescription.appendText("Получен: ").appendValue(new SimpleDateFormat(format).format(item));
    }

    @Override
    public void describeTo(Description description) {
        description.appendValue(toCompare).appendText(" в формате {").appendText(format).appendText("}.");
    }



    @Factory
    public static DateFormatMatcher dayOfWeekShort(String day) {
        return new DateFormatMatcher("EEE", day);
    }

    @Factory
    public static DateFormatMatcher dayOfMonth(Integer day) {
        return new DateFormatMatcher("d 'день месяца'", day.toString() + " день месяца");
    }

    @Factory
    public static DateFormatMatcher today() {
        String format = "'(Сегодня должен быть)' D 'день года' yyyy";
        SimpleDateFormat frm = new SimpleDateFormat(format);
        return new DateFormatMatcher(format, frm.format(new Date(System.currentTimeMillis())));
    }

    @Factory
    public static DateFormatMatcher tomorrow() {
        return afterDays(1);
    }


    @Factory
    public static DateFormatMatcher afterDays(Integer days) {
        String format = "'(Должен быть)' D 'день года' yyyy";

        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(Calendar.DAY_OF_YEAR, days); // <--
        Date tomorrowDate = cal.getTime();

        SimpleDateFormat frm = new SimpleDateFormat(format);
        String tomorrow = frm.format(tomorrowDate);
        return new DateFormatMatcher(format, tomorrow);
    }
}
