package ru.yandex.autotests.innerpochta.tomita.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 28.09.12
 * Time: 15:58
 */
public class DateMatcher extends TypeSafeMatcher<Date> {
    private int equality;

    public static final int BEFORE = -1;
    public static final int EQUAL = 0;
    public static final int AFTER = 1;

    public DateMatcher(int equality) {
        this.equality = equality;
    }

    @Override
    protected void describeMismatchSafely(Date item, Description mismatchDescription) {
        mismatchDescription.appendText("Получена дата ")
                .appendValue(item);
    }

    @Override
    protected boolean matchesSafely(Date item) {
        return equality == item.compareTo(new Date(System.currentTimeMillis()));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Текущая дата ")
                .appendValue(new Date(System.currentTimeMillis()));
        if (equality == AFTER) {
            description.appendText(" меньше ");
        } else if (equality == BEFORE) {
            description.appendText(" больше ");
        } else {
            description.appendText(" равно ");
        }

        description.appendText("полученной. ");

    }


    @Factory
    public static DateMatcher afterCurrent() {
        return new DateMatcher(AFTER);
    }

}
