package ru.yandex.autotests.innerpochta.tomita.prepare;

import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaDataCollector;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaDataPublisher;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.io.IOException;
import java.util.List;

import static com.google.common.collect.Iterables.concat;
import static com.google.common.collect.Lists.newArrayList;
import static ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils.*;
import static ru.yandex.autotests.innerpochta.tomita.core.beans.Component.*;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.selectBy;

/**
 * User: alex89
 * Date: 24.07.13
 * https://st.yandex-team.ru/AUTOTESTPERS-60
 * Список всех адресов смотреть здесь:
 * http://qa.yandex-team.ru/storage/get/tomita/testdata/pathlist-lamertester2210001110028383812.txt
 * http://qa.yandex-team.ru/storage/get/tomita/testdata/pathlist-eticket.type2170000570000032357.txt
 */

@Aqua.Test
@Title("Генератор тестовых данных - Сборный")
@Description("Достаем письма у конкретного пользователя, парсим письма и заливаем тексты в Элиптикс. " +
        "https://wiki.yandex-team.ru/users/kohen/iex-aas/results")
@Features({"TOMITA", "GENERATOR"})
@Stories("Общий")
@RunWith(Parameterized.class)
public class TomitaDataPrepare {
    public static final List<Component> COMPONENTS = newArrayList(TICKETS, UNSUBSCRIBE, HOTELS,
            CONTACTS, BOUNCE, REGISTRATION, CLOUD, DELIVERY);


    @Parameterized.Parameters(name = "{1}-{3}")
    public static Iterable<Object[]> data() throws IOException {
        Iterable<Object[]> data = newArrayList();
        for (Component component : COMPONENTS) {
            data = concat(data, messagesFor(component));
        }
        return data;
    }


    private DefaultHttpClient authHc;

    private DataBean bean;

    public TomitaDataPrepare(DefaultHttpClient hc, Component component, String fid, String mid) {
        this.authHc = hc;
        bean = DataBean.fromMid(mid).fid(fid).component(component);
    }


    @ClassRule
    public static TomitaDataPublisher collect = TomitaDataPublisher.withComponents(COMPONENTS);

    public TomitaDataCollector upload = TomitaDataCollector.withPublisher(collect);

    @Rule
    public RuleChain aqua = new LogConfigRule().around(upload);


    @Test
    public void extractTextAndSaveToBean() throws Exception {
        collect.canSaveNow();
        DataBean populated = populate(bean, authHc);
        upload.setData(populated);

        // Спрашиваем прод-ответ
        String url = ContentGenUtils.respUrl(populated);

        upload.reqUrl(selectBy(populated).uri()).respDataUrl(url);
    }
}

