package ru.yandex.autotests.innerpochta.tomita.prepare;

import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils;
import ru.yandex.autotests.innerpochta.tomita.core.beans.Component;
import ru.yandex.autotests.innerpochta.tomita.core.beans.DataBean;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaDataCollector;
import ru.yandex.autotests.innerpochta.tomita.core.rules.TomitaDataPublisher;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.io.IOException;
import java.util.List;

import static ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils.messagesFor;
import static ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils.respUrl;
import static ru.yandex.autotests.innerpochta.tomita.core.beans.Component.ADDR;
import static ru.yandex.autotests.innerpochta.tomita.core.beans.Component.DATE;
import static ru.yandex.autotests.innerpochta.tomita.core.beans.Component.EVENTS;
import static ru.yandex.autotests.innerpochta.tomita.core.opers.Factextract.selectBy;

/**
 * User: alex89
 * Date: 24.07.13
 * https://st.yandex-team.ru/AUTOTESTPERS-60
 * Список всех адресов смотреть здесь:
 */

@Aqua.Test
@Title("Генератор тестовых данных - Факты, Даты, Адреса")
@Description("Генерируем для фактов, дат и адресов")
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@RunWith(Parameterized.class)
@Features({"TOMITA", "GENERATOR"})
public class TomitaDataPrepareEvents {

    @Parameterized.Parameters(name = "{3}")
    public static Iterable<Object[]> data() throws IOException {
        List<Object[]> objects = messagesFor(EVENTS);
        return objects.subList(0, objects.size() > 700 ? 700 : objects.size() - 1);
    }

    private static DataBean populated;
    private DefaultHttpClient authHc;
    private DataBean bean;


    public TomitaDataPrepareEvents(DefaultHttpClient hc, Component component, String fid, String mid) {
        this.authHc = hc;
        bean = DataBean.fromMid(mid).fid(fid).component(component);
    }


    @ClassRule
    public static TomitaDataPublisher collect = TomitaDataPublisher.withComponents(EVENTS, DATE, ADDR);

    public TomitaDataCollector upload = TomitaDataCollector.withPublisher(collect);

    @Rule
    public RuleChain aqua = new LogConfigRule().around(upload);


    @Test
    public void aExtractText() throws Exception {
        collect.canSaveNow();
        populated = ContentGenUtils.populate(bean, authHc);
    }

    @Test
    @Stories("Факты")
    public void extractEvents() throws Exception {
        DataBean events = DataBean.fromBean(populated).component(EVENTS);
        upload.setData(events);

        // Спрашиваем прод-ответ
        String url = respUrl(events);
        upload.reqUrl(selectBy(events).uri()).respDataUrl(url);
    }

    @Test
    @Stories("Даты")
    public void extractDate() throws Exception {
        DataBean date = DataBean.fromBean(populated).component(DATE);
        upload.setData(date);

        // Спрашиваем прод-ответ
        String url = respUrl(date);
        upload.reqUrl(selectBy(date).uri()).respDataUrl(url);
    }

    @Test
    @Stories("Адреса")
    public void extractAddr() throws Exception {
        DataBean addr = DataBean.fromBean(populated).component(ADDR);
        upload.setData(addr);

        // Спрашиваем прод-ответ
        String url = respUrl(addr);
        upload.reqUrl(selectBy(addr).uri()).respDataUrl(url);
    }


}

