package ru.yandex.autotests.innerpochta.tomita.prepare;

import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SCPOutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.innerpochta.tomita.core.ContentGenUtils;
import ru.yandex.autotests.innerpochta.wmi.core.rules.SSHRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import javax.mail.MessagingException;
import java.io.IOException;

import static org.apache.commons.io.IOUtils.toByteArray;

/**
 * User: alex89
 * Date: 24.07.13
 * https://st.yandex-team.ru/AUTOTESTPERS-60
 * Список всех адресов смотреть здесь:
 * http://qa.yandex-team.ru/storage/get/tomita/testdata/pathlist-lamertester2210001110028383812.txt
 * http://qa.yandex-team.ru/storage/get/tomita/testdata/pathlist-eticket.type2170000570000032357.txt
 */

@Aqua.Test
@Title("Подготовка WMI хоста")
@Description("Прописываем нужный хост томиты в конфиг\n" +
        "https://wiki.yandex-team.ru/Testirovanie/FuncTesting/Communication/Mail/testplans/factextract")
@Features({"TOMITA", "GENERATOR"})
@Stories("WMI")
public class TomitaPrepareWmiHost {

    public static final String SCRIPT_NAME = "tomita.sh";
    public static final String TMP_REMOTE_PATH = "/tmp/";


    private Logger log = LogManager.getLogger(this.getClass());


    @ClassRule
    public static SSHRule ssh = new SSHRule();

    @Rule
    public LogConfigRule aqua = new LogConfigRule();


    @Test
    @Description("Отправка и выполнение скрипта по подготовке WMI машинки - подменяем в конфиге адрес томиты")
    public void execScript() throws IOException, MessagingException {
        log.trace("Send script...");
        byte[] bytes = fromClasspath("ssh/tomita.sh");
        try (SCPOutputStream put = new SCPClient(ssh.conn()).put(SCRIPT_NAME, bytes.length, TMP_REMOTE_PATH, "0755")) {
            put.write(bytes);
        }

        String result = ContentGenUtils.executeCommAndResturnResultAsString(ssh.conn(), TMP_REMOTE_PATH + SCRIPT_NAME);

        log.info(result);
    }

    private byte[] fromClasspath(String path) throws IOException {
        return toByteArray(this.getClass().getClassLoader().getResourceAsStream(path));
    }
}

