package ru.yandex.autotests.innerpochta.wmi.base;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runners.model.MultipleFailureException;
import ru.yandex.autotests.innerpochta.wmi.core.exceptions.RetryException;
import ru.yandex.autotests.innerpochta.wmi.core.obj.factory.MailSendMsgObjFactory;
import ru.yandex.autotests.innerpochta.wmi.core.rules.*;
import ru.yandex.autotests.innerpochta.wmi.core.rules.acclock.AccLockRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.LogCollectRule;
import ru.yandex.autotests.innerpochta.wmi.core.utils.SendUtils;
import ru.yandex.autotests.innerpochta.wmi.core.utils.WaitUtils;
import ru.yandex.autotests.lib.junit.rules.retry.RetryRule;
import ru.yandex.autotests.plugins.testpers.LogConfigRule;
import ru.yandex.autotests.testpers.ssh.SSHAuthRule;

import java.net.URI;
import java.util.concurrent.TimeUnit;

import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.auth;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.IgnoreRule.newIgnoreRule;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.IgnoreSshTestRule.newIgnoreSshTestRule;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.WriteAllureParamsRule.writeParamsForAllure;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.XRequestIdRule.xRequestIdRule;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.local.LogCollectRule.withGrepAllLogsFor;
import static ru.yandex.autotests.testpers.ssh.SSHAuthRule.sshOn;

public abstract class BaseTest {

    @ClassRule
    public static SSHAuthRule sshAuthRule = sshOn(URI.create(props().betaHost()), props().getRobotGerritWebmailTeamSshKey());

    public static AccLockRule lock = new AccLockRule();

    public static HttpClientManagerRule authClient = auth().withAnnotation().lock(lock);

    @ClassRule
    public static RuleChain chainAuth = RuleChain.outerRule(lock).around(authClient);

    @ClassRule
    public static IgnoreRule beforeTestClass = newIgnoreRule();

    @ClassRule
    public static IgnoreSshTestRule beforeSshTestClass = newIgnoreSshTestRule();

    @Rule
    public IgnoreSshTestRule beforeSshTest = newIgnoreSshTestRule();

    @Rule
    public IgnoreRule beforeTest = newIgnoreRule();

    @Rule
    public LogCollectRule logs = withGrepAllLogsFor(sshAuthRule);

    @Rule
    public TestRule chainRule = RuleChain
            .outerRule(new LogConfigRule())
            .around(new UpdateHCFieldRule(authClient, this, "hc"));

    @Rule
    public UtilsRule utils = new UtilsRule(authClient);

    public static InitialFolderList folderList = new InitialFolderList(authClient);
    public static InitialLabels labels = new InitialLabels(authClient);
    public static InitialComposeCheck composeCheck = new InitialComposeCheck(authClient);

    public SendUtils sendWith = new SendUtils(authClient).folderList(folderList).composeCheck(composeCheck);
    public static WaitUtils waitWith = new WaitUtils(authClient).folderList(folderList);

    @Rule
    public WriteAllureParamsRule writeAllureParamsRule = writeParamsForAllure();

    @Rule
    public XRequestIdRule setXRequestId = xRequestIdRule();

    @Rule
    public RetryRule retryRule = RetryRule.retry().ifException(RetryException.class)
            .or()
            .ifException(MultipleFailureException.class)
            .or()
            //эксперимент
            .ifException(AssertionError.class)
            .every(1, TimeUnit.SECONDS).times(1);


    protected DefaultHttpClient hc;

    protected final Logger logger = LogManager.getLogger(this.getClass());

    //фабрика для создания писем
    protected MailSendMsgObjFactory msgFactory = new MailSendMsgObjFactory()
            .setAccount(authClient.acc())
            .setComposeCheck(composeCheck);
}
