package ru.yandex.autotests.innerpochta.wmi.core;

import ch.lambdaj.function.convert.Converter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.LogManager;
import org.junit.internal.AssumptionViolatedException;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collection;

import static ch.lambdaj.Lambda.convert;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 13.05.13
 * Time: 23:46
 */
public class Common {
    public static Collection<Object[]> toParameterized(Collection<? extends Object> what) {
        return convert(what, new Converter<Object, Object[]>() {
            @Override
            public Object[] convert(Object from) {
                return new Object[]{from};
            }
        });
    }


    public static String entityToString(final HttpEntity entity, final Charset defaultCharset) throws IOException {
        try {
            return EntityUtils.toString(entity, defaultCharset);
        } catch (IllegalCharsetNameException e) {
            LogManager.getLogger(Common.class).warn(String.format("Can't parse: [%s] (part <%s>), use default - %s",
                    entity.getContentType(),
                    e.getCharsetName(),
                    defaultCharset.displayName()
            ));
            return IOUtils.toString(entity.getContent(), defaultCharset.displayName());
        } catch (OutOfMemoryError error) {
            throw new AssumptionViolatedException("Невозможно прочитать тело, оно слишком большое!", error);
        }
    }
}
