package ru.yandex.autotests.innerpochta.wmi.core.api;


import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;

import java.util.function.Function;

import static com.jayway.restassured.RestAssured.given;
import static org.apache.log4j.Logger.getLogger;
import static ru.yandex.autotests.innerpochta.RestAssuredLoggingFilter.log;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Headers;


/**
 * Created by puffyfloof on 07.10.16.
 */
public class CommonApiSettings {
    public static RequestSpecification baseWmiSpec(){
        return given()
            .spec(specBuilder()
                    .build())
                .filter(log().logger(getLogger(CommonApiSettings.class)).common(true));
    }

    public static RequestSpecification baseSettingsSpec() {
        RequestSpecBuilder spec = new RequestSpecBuilder()
                .setConfig(RestAssuredConfig.config()
                        .objectMapperConfig(ObjectMapperConfig.objectMapperConfig().defaultObjectMapperType(ObjectMapperType.GSON))
                        .encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset("UTF-8"))
                        .decoderConfig(DecoderConfig.decoderConfig().defaultContentCharset("UTF-8")));

        return given()
                .spec(spec.build())
                .filter(log().logger(getLogger(CommonApiSettings.class)).common(true));
    }

    public static RequestSpecBuilder specBuilder() {
        return new RequestSpecBuilder()
                .setConfig(RestAssuredConfig.config()
                .objectMapperConfig(ObjectMapperConfig.objectMapperConfig().defaultObjectMapperType(ObjectMapperType.GSON))
                .encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset("UTF-8"))
                .decoderConfig(DecoderConfig.decoderConfig().defaultContentCharset("UTF-8")))
                .setBaseUri(props().betaURI())
                .addHeader(Headers.REQUEST_ID, props().getCurrentRequestId());
    }

    public static Function<Response, Response> shouldBe(ResponseSpecification respSpec){
        return response -> response.then().spec(respSpec).extract().response();
    }
}
