package ru.yandex.autotests.innerpochta.wmi.core.api;

import com.jayway.restassured.builder.RequestSpecBuilder;
import ru.yandex.autotests.innerpochta.wmi.core.base.props.TvmProperties;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Headers;
import ru.yandex.autotests.innerpochta.wmi.core.mbody.ApiMbody;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.baseWmiSpec;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

public class MbodyApi {
    public static ApiMbody apiMbody() {
        return ApiMbody.mbody(ApiMbody.Config.mbodyConfig()
            .withReqSpecSupplier(() ->
                new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                    .setBaseUri(props().mbodyUri())));
    }

    public static ApiMbody apiMbody(String userTicket) {
        return apiMbody(userTicket, props().mbodyUri());
    }

    public static ApiMbody apiMbody(String userTicket, String host) {
        return ApiMbody.mbody(ApiMbody.Config.mbodyConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(host)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("mbody"))
                                .addHeader(Headers.USER_TICKET, userTicket)));
    }
}
