package ru.yandex.autotests.innerpochta.wmi.core.api;

import com.jayway.restassured.builder.RequestSpecBuilder;
import ru.yandex.autotests.innerpochta.wmi.core.base.props.TvmProperties;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Headers;
import ru.yandex.autotests.innerpochta.wmi.core.mops.ApiMops;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.baseWmiSpec;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

public class MopsApi {
    public static ApiMops apiMops(String userTicket) {
        return ApiMops.mops(ApiMops.Config.mopsConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(props().mopsUri())
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("mops"))
                                .addHeader(Headers.USER_TICKET, userTicket)));
    }
}
