package ru.yandex.autotests.innerpochta.wmi.core.api;

import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.response.Cookies;
import ru.yandex.autotests.innerpochta.wmi.core.akita.ApiAkita;
import ru.yandex.autotests.innerpochta.wmi.core.barbet.ApiBarbet;
import ru.yandex.autotests.innerpochta.wmi.core.base.props.TvmProperties;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Headers;
import ru.yandex.autotests.innerpochta.wmi.core.hound.ApiHound;
import ru.yandex.autotests.innerpochta.wmi.core.sendbernar.ApiSendbernar;
import ru.yandex.autotests.innerpochta.wmi.core.spaniel.ApiSpaniel;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.ApiShiva;

import java.util.Map;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.baseSettingsSpec;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.baseWmiSpec;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

public class WmiApis {
    public static final String clientType = "type";
    public static final String clientVersion = "version";

    public static ApiBarbet apiBarbet(String ticket) {
        return apiBarbet(ticket, props().barbetUri());
    }

    public static ApiBarbet apiBarbet(String ticket, String host) {
        return ApiBarbet.barbet(ApiBarbet.Config.barbetConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(host)
                                .addHeader(Headers.CLIENT_TYPE, clientType)
                                .addHeader(Headers.CLIENT_VERSION, clientVersion)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("barbet"))
                                .addHeader(Headers.USER_TICKET, ticket)));
    }

    public static ApiShiva apiShiva(String ticket) {
        return apiShiva(ticket, props().shivaUri());
    }

    public static ApiShiva apiShiva(String ticket, String host) {
        return ApiShiva.shiva(ApiShiva.Config.shivaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(host)
                                .addHeader(Headers.CLIENT_TYPE, clientType)
                                .addHeader(Headers.CLIENT_VERSION, clientVersion)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("shiva"))
                                .addHeader(Headers.USER_TICKET, ticket)));
    }

    public static ApiSendbernar apiSendbernar(String ticket) {
        return apiSendbernar(ticket, props().sendbernarUri());
    }

    public static ApiSendbernar apiSendbernar(String ticket, String host) {
        return ApiSendbernar.sendbernar(ApiSendbernar.Config.sendbernarConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(host)
                                .addHeader(Headers.CLIENT_TYPE, clientType)
                                .addHeader(Headers.CLIENT_VERSION, clientVersion)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("sendbernar"))
                                .addHeader(Headers.USER_TICKET, ticket)));
    }

    public static ApiHound apiHound(String ticket) {
        return apiHound(ticket, props().houndUri());
    }

    public static ApiHound apiHound(String ticket, String houndUri) {
        return ApiHound.hound(ApiHound.Config.houndConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(houndUri)
                                .addHeader(Headers.CLIENT_TYPE, clientType)
                                .addHeader(Headers.CLIENT_VERSION, clientVersion)
                                .addHeader(Headers.USER_TICKET, ticket)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("hound"))
                                .addHeader(Headers.WMI_TESTS, "hound")));
    }

    public static ru.yandex.autotests.innerpochta.wmi.core.hound.v2.ApiHound apiHoundV2(String ticket) {
        return ru.yandex.autotests.innerpochta.wmi.core.hound.v2.ApiHound.hound(ru.yandex.autotests.innerpochta.wmi.core.hound.v2.ApiHound.Config.houndConfig()
            .withReqSpecSupplier(() ->
                new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                    .setBaseUri(props().houndUri() + "/v2")
                    .addHeader(Headers.CLIENT_TYPE, clientType)
                    .addHeader(Headers.CLIENT_VERSION, clientVersion)
                    .addHeader(Headers.USER_TICKET, ticket)
                    .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("hound"))
                    .addHeader(Headers.WMI_TESTS, "hound_v2")));
    }

    public static ApiAkita apiAkita(Map<String, String> cookies) {
        return ApiAkita.akita(ApiAkita.Config.akitaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder()
                                .addRequestSpecification(baseWmiSpec())
                                .setBaseUri(props().akitaUri())
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("akita"))
                                .addCookies(cookies)
                ));
    }

    public static ApiAkita apiAkita(Map<String, String> cookies, String akitaUri) {
        return ApiAkita.akita(ApiAkita.Config.akitaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder()
                                .addRequestSpecification(baseSettingsSpec())
                                .setBaseUri(akitaUri)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("akita"))
                                .addCookies(cookies)
                ));
    }

    public static ApiAkita apiAkita(Cookies cookies) {
        return ApiAkita.akita(ApiAkita.Config.akitaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder()
                                .addRequestSpecification(baseWmiSpec())
                                .setBaseUri(props().akitaUri())
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("akita"))
                                .addCookies(cookies)
                ));
    }

    public static ApiAkita apiAkitaWithoutAuth() {
        return ApiAkita.akita(ApiAkita.Config.akitaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder()
                                .addRequestSpecification(baseWmiSpec())
                                .setBaseUri(props().akitaUri())
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("akita"))
                ));
    }

    public static ApiAkita apiAkitaOAuth(String token) {
        return ApiAkita.akita(ApiAkita.Config.akitaConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder()
                                .addRequestSpecification(baseWmiSpec())
                                .setBaseUri(props().akitaUri())
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("akita"))
                                .addHeader("Authorization", "OAuth " + token)
                ));
    }

    public static ApiSpaniel apiSpaniel(String ticket) {
        return apiSpaniel(ticket, props().spanielUri());
    }

    public static ApiSpaniel apiSpaniel(String ticket, String host) {
        return ApiSpaniel.spaniel(ApiSpaniel.Config.spanielConfig()
                .withReqSpecSupplier(() ->
                        new RequestSpecBuilder().addRequestSpecification(baseWmiSpec())
                                .setBaseUri(host)
                                .addHeader(Headers.CLIENT_TYPE, clientType)
                                .addHeader(Headers.CLIENT_VERSION, clientVersion)
                                .addHeader(Headers.SERVICE_TICKET, TvmProperties.props().ticketFor("spaniel"))
                                .addHeader(Headers.USER_TICKET, ticket)));
    }
}
