package ru.yandex.autotests.innerpochta.wmi.core.base;

import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.impl.client.DefaultHttpClient;
import ru.yandex.autotests.innerpochta.wmi.core.filter.Filter;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static org.apache.commons.lang.StringUtils.defaultIfEmpty;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.12.12
 * Time: 22:59
 */
public class Context {

    private List<Filter> filters;

    private String command;
    private String host;

    private String description;
    private Obj obj;
    private RequestExecutor.RequestType requestType;
    private DefaultHttpClient hc;
    private Class<? extends Oper> respClass;

    private Iterator<Filter> filterReqIterator;
    private Iterator<Filter> filterRespIterator;


    public Context resp(Class<? extends Oper> respClass) {
        this.respClass = respClass;
        return this;
    }


    public Class<? extends Oper> resp() {
        return respClass;
    }


    public Context filters(List<Filter> filters) {
        if (null == filters) {
            this.filters = new ArrayList<Filter>(1);
        } else {
            if (this.filters == null) {
                this.filters = filters;
            } else {
                this.filters.addAll(filters);
            }
        }

        reset();
        return this;
    }

    public List<Filter> filters() {
        return filters;
    }

    public String url() {
        return host + command;
    }

    public Context host(String host) {
        this.host = defaultIfEmpty(host, props().betaHost());
        return this;
    }

    public Context cmd(String command) {
        this.command = command;
        return this;
    }

    public String cmd() {
        if (command == null) {
            throw new RuntimeException(respClass.getSimpleName() + " содержит null вместо комманды");
        }
        return command;
    }

    public String descr() {
        return description;
    }

    public Context descr(String description) {
        this.description = description;
        return this;
    }

    public Obj params() {
        return obj;
    }

    public Context params(Obj obj) {
        this.obj = obj;
        return this;
    }

    public RequestExecutor.RequestType requestType() {
        return requestType;
    }

    public Context requestType(RequestExecutor.RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public DefaultHttpClient client() {
        return hc;
    }

    public Context client(DefaultHttpClient hc) {
        this.hc = hc;
        return this;
    }


    /**
     * Исполняет следующий фильтрр в цепочке для запроса
     *
     * @param request - объект запроса
     * @return объект запроса после фильтра
     */
    public Request next(Request request) {
        if (!filterReqIterator.hasNext()) {
            return request;
        }
        return filterReqIterator.next().filter(request, this);
    }


    /**
     * Исполняет следующий фильтр в цепочке для объектов ответа
     *
     * @param response - объект ответа
     * @return объект ответа после обработки фильтром
     * @throws java.io.IOException
     */
    public HttpResponse next(HttpResponse response) throws IOException {
        if (!filterRespIterator.hasNext()) {
            return response;
        }
        return filterRespIterator.next().filter(response, this);
    }


    public Context reset() {
        filterReqIterator = filters.iterator();
        filterRespIterator = filters.iterator();
        return this;
    }
}