package ru.yandex.autotests.innerpochta.wmi.core.base;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import ru.yandex.autotests.innerpochta.objstruct.base.misc.Account;
import ru.yandex.autotests.innerpochta.wmi.core.obj.factory.MailSendMsgObjFactory;
import ru.yandex.autotests.innerpochta.wmi.core.oper.ComposeCheck;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 11:06
 */
public class Creator {
    /**
     * Переменная, сохраняющая необходимые ключи, суиды итд.
     * Для того, чтобы не запрашивать каждый раз
     */
    private ComposeCheck composeCheck;

    /**
     * HttpClient API 4
     */
    protected DefaultHttpClient httpClient4;

    /**
     * Текущий аккаунт - нужен для инициализации настроек некоторых фабрик
     */
    protected Account account;

    /**
     * Логгер
     */
    protected Logger logger = Logger.getLogger(this.getClass());


    /**
     * Конструктор с установкой http клиента версии 4
     * Необходим для получения некоторых значений по-умолчанию для фабрик
     *
     * @param httpClient4 - DefaultHttpClient
     * @param account     - аккаунт текущего http клиента
     */
    public Creator(DefaultHttpClient httpClient4, Account account) {
        this.httpClient4 = httpClient4;
        this.account = account;
    }

    //-----------------------------------------------------------------------------------------------
    // Фабрики по созданию объектов
    //-----------------------------------------------------------------------------------------------

    /**
     * Возвращает фабрику по производству писем
     * Инициализирует начальные установки:
     * - compose_check
     *
     * @return Фабрика писем
     */
    public MailSendMsgObjFactory getMailSendMsgObjFactory() {
        MailSendMsgObjFactory factory = new MailSendMsgObjFactory();

        factory.setComposeCheck(initComposeCheck().getComposeCheckNodeValue());
        factory.setAccount(account);
        return factory;
    }


    //--------------------------------------------------------------------------------------------
    // Функции начальных установок
    //---------------------------------------------------------------------------------------------

    /**
     * @return ответ от compose_check
     */
    private ComposeCheck initComposeCheck() {
        try {
            if (null == composeCheck) { // Если еще не инициализировали, то делаем это
                composeCheck = api(ComposeCheck.class).post().via(httpClient4);
            }
            return composeCheck;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    //------------------------------------------------------------------------

}
