package ru.yandex.autotests.innerpochta.wmi.core.base;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.EmptyWmiOper;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static java.lang.String.format;
import static org.fest.reflect.core.Reflection.constructor;
import static org.fest.reflect.core.Reflection.field;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.OperChangeFilter.OperChangeFilterBuilder.changeOper;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.12.12
 * Time: 16:47
 */
public class Exec {
    public enum CmdType {JSX, API}

    /**
     * Создает экземпляр переданного класса и заполняет его поля значениями из аннотации
     *
     * @param clazz - класс для инстанцирования
     * @param <T>   - тип операции-ответа
     * @return экземпляр переданного класса
     */
    private static <T extends Oper> T create(Class<T> clazz, CmdType type, Object... urlFormatterParts) {
        shouldBeOperAnnotation(clazz);
        OperClass annotation = clazz.getAnnotation(OperClass.class);

        T instance = constructor().in(clazz).newInstance();

        field("description").ofType(String.class).in(instance).set(annotation.description());
        String cmd = format(getCmd(type, annotation), urlFormatterParts);
        field("command").ofType(String.class).in(instance).set(cmd);
        instance.log(log());

        return instance;

    }

    private static <T extends Oper> void shouldBeOperAnnotation(Class<T> clazz) {
        if (!clazz.isAnnotationPresent(OperClass.class)) {
            throw new IllegalStateException(clazz.getSimpleName() + " должен быть помечен аннотацией " +
                    OperClass.class.getSimpleName());
        }
    }

    public static <T extends Oper> T jsx(Class<T> clazz) {
        return create(clazz, CmdType.JSX);
    }


    public static <T extends Oper> T api(Class<T> clazz, Object... urlFormatterParts) {
        return create(clazz, CmdType.API, urlFormatterParts);
    }


    public static <T extends Oper> T api(Class<T> clazz) {
        return create(clazz, CmdType.API);
    }

    public static EmptyWmiOper any(String prefix, String method, String hint) {
        return api(EmptyWmiOper.class)
                .filters(0, changeOper().prefix(prefix).method(method).description(hint).build());
    }

    private static String getCmd(CmdType type, OperClass annotation) {
        switch (type) {
            case API:
                return annotation.apipath() + annotation.apicommand();
            default:
            case JSX:
                return annotation.jsxpath() + "?" + annotation.jsxprefix() + "=" + annotation.jsxcommand();
        }
    }
}


