package ru.yandex.autotests.innerpochta.wmi.core.base;

import ch.ethz.ssh2.Connection;
import com.google.common.base.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import ru.yandex.autotests.innerpochta.util.ssh.SSHCommands;
import ru.yandex.autotests.innerpochta.wmi.core.filter.Filter;
import ru.yandex.autotests.innerpochta.wmi.core.obj.EmptyObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.io.IOException;
import java.util.List;

import static java.text.MessageFormat.format;
import static org.apache.log4j.Logger.getLogger;
import static ru.yandex.autotests.innerpochta.wmi.core.Common.entityToString;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.12.12
 * Time: 22:55
 */
public class RequestExecutor {
    public enum RequestType {GET, POST, HEAD}

    private Context ctx = new Context();

    public RequestExecutor host(String host) {
        ctx.host(host);
        return this;
    }

    public RequestExecutor cmd(String command) {
        ctx.cmd(command);
        return this;
    }

    public RequestExecutor descr(String description) {
        ctx.descr(description);
        return this;
    }

    public RequestExecutor with(Obj obj) {
        ctx.params(obj);
        return this;
    }

    public RequestExecutor requestType(RequestType requestType) {
        ctx.requestType(requestType);
        return this;
    }

    public RequestExecutor filters(List<Filter> filters) {
        ctx.filters(filters);
        return this;
    }

    public RequestExecutor client(DefaultHttpClient hc) {
        ctx.client(hc);
        return this;
    }

    public <T extends Oper> String execute(final T someResp)
            throws IOException {
        ctx.resp(someResp.getClass());


        Request request = ctx.reset().next(createRequest(ctx));
        return Executor.newInstance(ctx.client())
                .execute(request)
                .handleResponse(response -> {
                    HttpResponse bufferedResponse = wrap(response);
                    bufferedResponse = ctx.next(bufferedResponse);

                    String strResp = entityToString(response.getEntity(), Charsets.UTF_8);

                    //SETTING THE RESPONSE
                    someResp.setStatusLine(bufferedResponse.getStatusLine());
                    someResp.setRespAsString(strResp);
                    // Converter - inside
                    return strResp;
                });
    }


    public <T extends Oper> byte[] bytes(final T someResp)
            throws IOException {
        ctx.resp(someResp.getClass());

        Request request = ctx.reset().next(createRequest(ctx));
        return Executor.newInstance(ctx.client())
                .execute(request)
                .handleResponse(response -> {
                    HttpResponse bufferedResponse = wrap(response);
                    bufferedResponse = ctx.next(bufferedResponse);

                    byte[] bytes = EntityUtils.toByteArray(bufferedResponse.getEntity());

                    //SETTING THE RESPONSE
                    someResp.setStatusLine(bufferedResponse.getStatusLine());
                    // Converter - inside
                    return bytes;
                });
    }

    private static HttpResponse wrap(HttpResponse response) throws IOException {
        response.setEntity(new BufferedHttpEntity(response.getEntity()));
        return response;
    }


    public <T extends Oper> String execute(final T someResp, Connection connection)
            throws IOException {
        ctx.resp(someResp.getClass());
        String cmd = createCurlRequest(ctx);

        ctx.descr("BY CURL: " + ctx.descr());
        ctx.host("(By curl) ").cmd(cmd).params(new EmptyObj());  // Оставляем для лога только саму команду
        ctx.reset().next(Request.Get(""));

        String resp = SSHCommands.executeCommAndResturnResultAsString(connection, cmd, getLogger(ctx.resp()));

        HttpResponse httpResponse = new BasicHttpResponse(
                new ProtocolVersion("HTTP 1.1", 1, 0), 100, "FAKE STATUS, SEE CURL");

        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(IOUtils.toInputStream(resp));
        entity.setContentLength(resp.length());
        entity.setContentEncoding("UTF-8");
        httpResponse.setEntity(new BufferedHttpEntity(entity));

        ctx.next(httpResponse);

        someResp.setStatusLine(httpResponse.getStatusLine());
        someResp.setRespAsString(resp);
        return resp;
    }

    public String getRequestAsString() {
        return ctx.url() + ctx.params().asGet(!ctx.cmd().contains("?"));
    }

    public static Request createRequest(Context ctx) {
        switch (ctx.requestType()) {
            default:
            case GET:
                return Request.Get(ctx.url() + ctx.params().asGet(!ctx.cmd().contains("?")));
            case POST:
                return Request.Post(ctx.url() + ctx.params().onlyQueryParams(!ctx.cmd().contains("?")))
                        .body(ctx.params().asPost());
        }
    }


    public static String createCurlRequest(Context ctx) {
        switch (ctx.requestType()) {
            default:
            case GET:
                return format("curl -k ''{0}{1}''", ctx.url(), ctx.params().asGet(!ctx.cmd().contains("?")));
            case POST:
                return format("curl -k  -X POST ''{0}{1}''", ctx.url(), ctx.params().asGet(!ctx.cmd().contains("?")));
            case HEAD:
                return format("curl -k -I ''{0}{1}''", ctx.url(), ctx.params().asGet(!ctx.cmd().contains("?")));
        }
    }
}
