package ru.yandex.autotests.innerpochta.wmi.core.base.props;

import ru.yandex.autotests.innerpochta.wmi.core.consts.Scopes;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.annotations.With;
import ru.yandex.qatools.properties.providers.MapOrSyspropPathReplacerProvider;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 26.03.15
 * Time: 17:37
 */
@Resource.Classpath("mock.properties")
@With(MapOrSyspropPathReplacerProvider.class)
public class MockProperties {
    private static MockProperties instance;

    public static MockProperties propsMock() {
        if (instance == null) {
            instance = new MockProperties();
        }
        return instance;
    }

    private MockProperties() {
        PropertyLoader.populate(this);
    }

    public MockProperties reset() {
        PropertyLoader.populate(this);
        return this;
    }

    @Property("karma.host")
    private String karmaHost;

    @Property("sanitizer.host")
    private String sanitizerHost;

    @Property("sanitizer.port")
    private int sanitizerPort;

    @Property("rca.host")
    private String rcaHost;

    @Property("rca.port")
    private int rcaPort;

    @Property("push.host")
    private String pushHost;

    @Property("settings.host")
    private String settingsHost;

    @Property("settings.port")
    private int settingsPort;

    @Property("postmaster.host")
    private String postmasterHost;

    @Property("postmaster.port")
    private int postmasterPort;

    @Property("shingler.host")
    private String shinglerHost;

    @Property("shingler.port")
    private int shinglerPort;

    @Property("tomita.host")
    private String tomitaHost;

    @Property("so.host.ugr")
    private String soUgrHost;

    @Property("so.host.iva")
    private String soIvaHost;

    @Property("so.host.myt")
    private String soMytHost;

    @Property("so.host.fol")
    private String soFolHost;

    @Property("so.host.sas")
    private String soSasHost;

    @Property("mops.host")
    private int mopsHost;

    @Property("mops.port")
    private int mopsPort;

    @Property("mops.port.fallback")
    private int mopsPortFallback;

    @Property("mbody.host")
    private int mbodyHost;

    @Property("mbody.port")
    private int mbodyPort;

    @Property("mbody.port.fallback")
    private int mbodyPortFallback;

    @Property("smtp.host")
    private String smtpHost;

    @Property("smtp.port")
    private int smtpPort;

    @Property("sophos.host")
    private String sophosHost;

    @Property("sophos.port")
    private int sophosPort;

    @Property("so.port")
    private int soPort;

    @Property("bb.host")
    private String bbHost;

    @Property("rpop.host")
    private String rpopHost;

    @Property("sharpei.host")
    private String sharpeiHost;

    @Property("sharpei.port")
    private int sharpeiPort;

    @Property("search.host")
    private String searchHost;

    @Property("search.port")
    private int searchPort;

    @Property("abook.host")
    private String abookHost;

    @Property("calendar.host")
    private String calendarHost;

    @Property("calendar.port")
    private int calendarPort;

    @Property("captcha.host")
    private String captchaHost;

    @Property("testing.scope")
    private String testingScope = Scopes.PRODUCTION.getName();

    public String getKarmaHost() {
        return karmaHost;
    }

    public String getSanitizerHost() {
        return sanitizerHost;
    }

    public int getSanitizerPort() {
        return sanitizerPort;
    }

    public String getRcaHost() {
        return rcaHost;
    }

    public int getRcaPort() {
        return rcaPort;
    }

    public String getPushHost() {
        return pushHost;
    }

    public String getSettingsHost() {
        return settingsHost;
    }

    public int getSettingsPort() {
        return settingsPort;
    }

    public String getPostmasterHost() {
        return postmasterHost;
    }

    public int getPostmasterPort() {
        return postmasterPort;
    }

    public String getShinglerHost() {
        return shinglerHost;
    }

    public int getShinglerPort() {
        return shinglerPort;
    }

    public String getTomitaHost() {
        return tomitaHost;
    }

    public int getMopsPort() {
        return mopsPort;
    }

    public int getMopsPortFallback() {
        return mopsPortFallback;
    }

    public int getSmtpPort() {
        return smtpPort;
    }

    public String getSmtpHost() {
        return smtpHost;
    }

    public int getMbodyHost() {
        return mbodyHost;
    }

    public int getMbodyPort() {
        return mbodyPort;
    }

    public int getMbodyPortFallback() {
        return mbodyPortFallback;
    }

    public String getBBHost() {
        return bbHost;
    }

    public String getRpopHost() {
        return rpopHost;
    }

    public String getSharpeiHost() {
        return sharpeiHost;
    }

    public int getSharpeiPort(){
        return sharpeiPort;
    }

    public String getSearchHost(){
        return searchHost;
    }

    public int getSearchPort(){
        return searchPort;
    }

    public String getAbookHost(){
        return abookHost;
    }

    public String getCalendarHost() {
        return calendarHost;
    }

    public int getCalendarPort(){
        return calendarPort;
    }

    public String getCaptchaHost(){
        return captchaHost;
    }
}
