package ru.yandex.autotests.innerpochta.wmi.core.base.props;

import gumi.builders.UrlBuilder;
import org.eclipse.jetty.http.HttpSchemes;
import ru.qatools.properties.Property;
import ru.qatools.properties.PropertyLoader;
import ru.qatools.properties.Resource;
import ru.qatools.properties.Use;
import ru.qatools.properties.providers.SysPropPathReplacerProvider;
import ru.yandex.autotests.innerpochta.objstruct.base.misc.Account;
import ru.yandex.autotests.innerpochta.wmi.core.base.anno.Credentials;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Scopes;
import ru.yandex.qatools.secrets.Secret;
import ru.yandex.qatools.secrets.SecretsLoader;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;

/**
 * User: lanwen
 * Date: 20.08.13
 * Time: 22:55
 */

@Resource.Classpath("wmi-core.${system.testing.scope}.properties")
public class WmiCoreProperties {
    static {
        if (!System.getProperties().containsKey("testing.scope")) {
            System.setProperty("testing.scope", "pg");
        }
    }

    private static WmiCoreProperties instance;

    public static WmiCoreProperties props() {
        if (instance == null) {
            instance = new WmiCoreProperties();
        }
        return instance;
    }

    private WmiCoreProperties() {
        PropertyLoader
                .newInstance()
                .withPropertyProvider(new SysPropPathReplacerProvider())
                .populate(this);

        SecretsLoader
                .populate(this);
    }

    public WmiCoreProperties reset() {
        PropertyLoader
                .newInstance()
                .withPropertyProvider(new SysPropPathReplacerProvider())
                .populate(this);

        SecretsLoader
                .populate(this);

        return this;
    }

    @Property("selenium.baseURL")
    private String betaHost = "https://wmi-qa.yandex.ru";

    @Property("mops.host")
    private String mopsHost = "https://wmi-qa.yandex.ru";

    @Property("mops.port")
    private int mopsPort = 8814;

    @Property("mops.threshold")
    private int mopsThreshold = 0;

    @Property("mopsdb.host")
    private String mopsdbHost = "localhost";

    @Property("mopsdb.port")
    private int mopsdbPort = 6432;

    @Property("mopsdb.user")
    private String mopsdbUser = "tech";

    @Property("mopsdb.dbname")
    private String mopsdbName = "mopsdb";

    @Secret("sec-01dvt5p21agmpz2fkx37e3yk77")
    private String mopsdbPgpass = "";

    @Property("mbody.host")
    private String mbodyHost = "https://mbody-test.mail.yandex.net";

    @Property("mbody.port")
    private int mbodyPort = 8888;

    @Property("hound.host")
    private String houndHost = "https://meta-test.mail.yandex.net";

    @Property("hound.port")
    private int houndPort = 80;

    @Property("akita.port")
    private int akitaPort = 11110;

    @Property("akita.host")
    private String akitaHost = "https://wmi-qa.yandex.ru";

    @Property("sendbernar.port")
    private int sendbernarPort = 9091;

    @Property("sendbernar.host")
    private String sendbernarHost = "https://wmi-qa.yandex.ru";

    @Property("spaniel.port")
    private int spanielPort = 80;

    @Property("spaniel.host")
    private String spanielHost = "https://wmi-qa.yandex.ru";

    @Property("shiva.port")
    private int shivaPort = 80;

    @Property("shiva.host")
    private String shivaHost = "https://shiva-test.mail.yandex.net";

    @Property("barbet.port")
    private int barbetPort = 80;

    @Property("barbet.host")
    private String barbetHost = "https://wmi-qa.yandex.ru";

    @Property("sendbernar.b2b.port")
    private int sendbernarB2bPort = 80;

    @Property("sendbernar.b2b.host")
    private String sendbernarB2bHost = "http://sendbernar-test.mail.yandex.net";

    @Property("passport.host")
    private URI passportHost = URI.create("https://passport.yandex.ru/");

    @Property("blackbox.host")
    private String blackboxHost = "http://blackbox.yandex.net";

    @Property("production.host")
    private String productionHost = "https://mail.yandex.ru";

    @Property("b2b.uri")
    private URI b2bUri = URI.create("https://web-qa-b2b.yandex.ru");

    @Property("hound.b2b.host")
    private String houndB2bHost = "https://web-qa-b2b.yandex.ru";

    @Property("hound.b2b.port")
    private int houndB2bPort = 9091;

    @Property("mbody.b2b.host")
    private String mbodyB2bHost = "https://web-qa-b2b.yandex.ru";

    @Property("mbody.b2b.port")
    private int mbodyB2bPort = 8888;

    @Property("b2b.chunk")
    private int b2bChunk = 100;

    @Property("webattach.host")
    private String webattachHost = "https://attach-qa.mail.yandex.net";

    @Property("webattach.stable")
    private String webattachStable = "http://webattach.mail.yandex.net";

    @Property("webattach.b2b")
    private String webattachB2b = "http://webattach.mail.yandex.net";

    @Property("vdirect.beta.uri")
    private URI vdirectBetaUri = URI.create("http://vdirect-qa.mail.yandex.net");

    @Property("log.version")
    private String logVersion = "aqua";

    @Property("sanitizer.port")
    private int sanitizerPort = 1010;

    @Property("use.default.wmi.user")
    private boolean useDefaultWmiUser = false;

    @Property("default.wmi.user.login")
    private String defaultWmiUserLogin = "";

    @Property("default.wmi.user.pwd")
    private String defaultWmiUserPwd = "";

    @Property("b2b.useless.nodes")
    private String b2bUselessNodes = "";

    @Property("ssh.login")
    private String sshLogin = "robot-aqua-testpers";

    @Property("ssh.password")
    private String sshPassword = "qwerty";

    @Property("testing.scope")
    private String testingScope = Scopes.PRODUCTION.getName();

    @Property("current.request.id")
    private String currentRequestId = "DefaultRequestId";

    @Property("is.local.debug")
    private boolean isLocalDebug = true;

    @Property("lock.accounts")
    private boolean lockAccounts = false;

    @Use(YamlConverter.class)
    @Property("mailboxes.yaml.file")
    private Map<String, List<Map<String, String>>> accounts = new HashMap<String, List<Map<String, String>>>() {{
        put(Credentials.DEFAULT_LOGIN_GROUP, newArrayList(new HashMap<String, String>() {{
            put("defaultuser", "testqa");
        }}));
    }};

    @Property("mulcagate.host")
    private String mulcagateHost = "http://storage.mail.yandex.net";

    @Property("mulcagate.port")
    private int mulcagatePort = 10010;

    @Property("ssh_tests.ignore")
    private boolean ignoreSshTests = false;

    @Secret("sec-01d1rntr10f8jyvc33qazewj37")
    private String robotGerritWebmailTeamSshKey = "";

    public String getRobotGerritWebmailTeamSshKey() {
        return robotGerritWebmailTeamSshKey;
    }

    public boolean isPg() {
        return Scopes.PRODUCTION.getName().equals(testingScope);
    }

    public boolean isLocalDebug() {
        return isLocalDebug;
    }

    public boolean isLocsAccounts() {
        return lockAccounts;
    }

    public String betaHost() {
        return betaHost;
    }

    public Scopes testingScope() {
        return Scopes.from(testingScope);
    }

    public Scopes scope() {
        return testingScope();
    }

    private static String makeUri(String host, int port) {
        UrlBuilder url = UrlBuilder.fromString(host);
        if (80 != port && url.scheme.equals(HttpSchemes.HTTP)) {
            url = url.withPort(port);
        }
        return url.toString();
    }

    public String akitaUri() {
        return makeUri(akitaHost, akitaPort);
    }

    public String houndUri() {
        return makeUri(houndHost, houndPort);
    }

    public String houndUri(String host) {
        return makeUri(host, houndPort);
    }

    public String houndB2bUri() {
        return makeUri(houndB2bHost, houndB2bPort);
    }

    public String mbodyUri() {
        return makeUri(mbodyHost, mbodyPort);
    }

    public String mbodyB2BUri() {
        return makeUri(mbodyB2bHost, mbodyB2bPort);
    }

    public String mopsUri() {
        return makeUri(mopsHost, mopsPort);
    }

    public String sendbernarUri() {
        return makeUri(sendbernarHost, sendbernarPort);
    }

    public String spanielUri() {
        return makeUri(spanielHost, spanielPort);
    }

    public String barbetUri() {
        return makeUri(barbetHost, barbetPort);
    }

    public String shivaUri() {
        return makeUri(shivaHost, shivaPort);
    }

    public String sendbernarB2bUri() {
        return makeUri(sendbernarB2bHost, sendbernarB2bPort);
    }

    public URI sanitizerUri() {
        return UrlBuilder.fromString(sanitizerHost())
                .withPort(sanitizerPort)
                .withScheme(HttpSchemes.HTTP).toUri();
    }

    public String on8079Host() {
        return on8079Host(betaHost());
    }

    public String on8079Host(String host) {
        return UrlBuilder.fromString(host)
                .withPort(8079)
                .withScheme(HttpSchemes.HTTP).toString();
    }

    public String httpHost() {
        return UrlBuilder.fromString(betaHost())
                .withScheme(HttpSchemes.HTTP).toString();
    }

    public String sanitizerHost() {
        return betaHost;
    }

    public String mopsHost() {
        return mopsHost;
    }

    public int mopsThreshold() {
        return this.mopsThreshold;
    }

    public String mopsdbHost() {
        return mopsdbHost;
    }

    public int mopsdbPort() {
        return mopsdbPort;
    }

    public String mopsdbUser() {
        return mopsdbUser;
    }

    public String mopsdbName() {
        return mopsdbName;
    }

    public String mopsdbPassword() {
        return getPasswordFromPgpass();
    }

    private String getPasswordFromPgpass() {
        String[] lines = mopsdbPgpass.split("\\n");
        for (String line : lines) {
            line = line.trim();
            if (line.isEmpty() || line.charAt(0) == '#') {
                continue;
            }

            String[] fields = line.split(":", 5);
            if (fields.length != 5) {
                throw new RuntimeException("Illformed line in pgpassfile: " + line);
            }

            if (fields[1].equals(String.valueOf(mopsdbPort)) &&
                fields[2].equals(mopsdbName) &&
                fields[3].equals(mopsdbUser)) {
                String password = fields[4]
                        .replaceAll("\\\\\\\\", "\\\\")
                        .replaceAll("\\\\:", ":");
                return password;
            }
        }
        throw new RuntimeException("Could not find password in pgpassfile");
    }

    public URI betaURI() {
        return URI.create(betaHost);
    }

    public URI passportHost() {
        return passportHost;
    }

    public String blackboxHost() {
        return blackboxHost;
    }

    public String productionHost() {
        return productionHost;
    }

    public URI b2bUri() {
        return b2bUri;
    }

    public int b2bChunk() {
        return b2bChunk;
    }

    public String webattachStable() {
        return webattachStable;
    }

    public String webattachB2b() {
        return webattachB2b;
    }

    public String webattachHost() {
        return UrlBuilder.fromString(webattachHost)
                .withScheme(HttpSchemes.HTTP).toString();
    }

    public String logVersion() {
        return logVersion;
    }

    public int houndPort() {
        return houndPort;
    }

    public String getB2bUselessNodes() {
        return b2bUselessNodes;
    }

    public String getDefaultWmiUserLogin() {
        return defaultWmiUserLogin;
    }

    public String getDefaultWmiUserPwd() {
        return defaultWmiUserPwd;
    }

    public String getSshLogin() {
        return sshLogin;
    }

    public String getSshPassword() {
        return sshPassword;
    }

    public Map<String, Account> accounts() {
        Map<String, Account> result = new HashMap<>();
        for (String key : accounts.keySet()) {
            result.put(key, account(key));
        }
        return result;
    }

    public <T> Account account(T bean) {
        return account(bean.getClass());
    }

    public Account account(Class<?> clazz) {
        return account(clazz.getSimpleName());
    }

    public Boolean isWebcorp() {
        return Scopes.INTRANET_PRODUCTION.getName().equals(testingScope);
    }

    public void setCurrentRequestId(String xRequestId) {
        this.currentRequestId = xRequestId;
    }

    public String getCurrentRequestId() {
        return currentRequestId;
    }

    public Account account(String loginGroup) {
        return accounts(loginGroup).get(0);
    }

    public List<Account> accounts(String loginGroup) {
        if (accounts.containsKey(loginGroup)) {
            List<Account> accountsList = newArrayList();
            accounts.get(loginGroup).forEach(map -> accountsList.add(new Account(map.get("login"),
                    map.get("pwd"))));
            return accountsList;

        } else {
            throw new IllegalArgumentException("В конфиге нет аккаунта для группы: " + loginGroup);
        }
    }

    public String mulcagateUri() {
        return UrlBuilder.fromString(mulcagateHost)
            .withPort(mulcagatePort)
            .withScheme(HttpSchemes.HTTP).toString();
    }

    public boolean ignoreSshTests() {
        return ignoreSshTests;
    }
}
